/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import org.xwiki.component.util.ReflectionUtils;

public class DefaultParameterizedType
implements ParameterizedType {
    private final Type[] actualTypeArguments;
    private final Type ownerType;
    private final Class<?> rawType;

    public DefaultParameterizedType(Type ownerType, Class<?> rawType, Type ... actualTypeArguments) {
        this.ownerType = ownerType;
        this.actualTypeArguments = actualTypeArguments;
        this.rawType = rawType;
    }

    public DefaultParameterizedType(ParameterizedType type) {
        this(type.getOwnerType(), (Class)type.getRawType(), type.getActualTypeArguments());
    }

    @Override
    public Type[] getActualTypeArguments() {
        return (Type[])this.actualTypeArguments.clone();
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    public int hashCode() {
        return Arrays.hashCode(this.actualTypeArguments) ^ Objects.hashCode(this.ownerType) ^ Objects.hashCode(this.rawType);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType parameterizedType = (ParameterizedType)o;
        return Objects.equals(this.rawType, parameterizedType.getRawType()) && Objects.equals(this.ownerType, parameterizedType.getOwnerType()) && Arrays.equals(this.actualTypeArguments, parameterizedType.getActualTypeArguments());
    }

    public String toString() {
        return ReflectionUtils.serializeType(this);
    }
}

