/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.descriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.descriptor.DefaultComponentDependency;
import org.xwiki.component.descriptor.DefaultComponentRole;

public class DefaultComponentDescriptor<T>
extends DefaultComponentRole<T>
implements ComponentDescriptor<T> {
    private Class<? extends T> implementation;
    private ComponentInstantiationStrategy instantiationStrategy = ComponentInstantiationStrategy.SINGLETON;
    private List<ComponentDependency<?>> componentDependencies = new ArrayList();

    public void setImplementation(Class<? extends T> implementation) {
        this.implementation = implementation;
    }

    @Override
    public Class<? extends T> getImplementation() {
        return this.implementation;
    }

    public void setInstantiationStrategy(ComponentInstantiationStrategy instantiationStrategy) {
        this.instantiationStrategy = instantiationStrategy;
    }

    @Override
    public ComponentInstantiationStrategy getInstantiationStrategy() {
        return this.instantiationStrategy;
    }

    @Override
    public Collection<ComponentDependency<?>> getComponentDependencies() {
        return this.componentDependencies;
    }

    public void addComponentDependency(ComponentDependency<?> componentDependency) {
        this.componentDependencies.add(componentDependency);
    }

    public <TT> void addComponentDependency(Class<TT> role, String roleHint) {
        DefaultComponentDependency<TT> componentDependency = new DefaultComponentDependency<TT>();
        componentDependency.setRole(role);
        componentDependency.setRoleHint(roleHint);
        this.componentDependencies.add(componentDependency);
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(super.toString());
        buffer.append(" implementation = [").append(this.getImplementation().getName()).append("]");
        buffer.append(" instantiation = [").append((Object)this.getInstantiationStrategy()).append("]");
        return buffer.toString();
    }
}

