/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Collection<Field> getAllFields(Class<?> clazz) {
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        for (Class<?> targetClass = clazz; targetClass != null; targetClass = targetClass.getSuperclass()) {
            Field[] targetClassFields;
            try {
                targetClassFields = targetClass.getDeclaredFields();
            }
            catch (NoClassDefFoundError e) {
                throw new NoClassDefFoundError("Failed to get fields for class [" + targetClass.getName() + "] because the class [" + e.getMessage() + "] couldn't be found in the ClassLoader.");
            }
            for (Field field : targetClassFields) {
                if (fields.containsKey(field.getName())) continue;
                fields.put(field.getName(), field);
            }
        }
        return fields.values();
    }

    public static Field getField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        Field resultField = null;
        for (Class<?> targetClass = clazz; targetClass != null; targetClass = targetClass.getSuperclass()) {
            try {
                resultField = targetClass.getDeclaredField(fieldName);
                break;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        if (resultField == null) {
            throw new NoSuchFieldException("No field named [" + fieldName + "] in class [" + clazz.getName() + "] or superclasses");
        }
        return resultField;
    }

    public static Class getTypeClass(Type type) {
        Class typeClassClass = type instanceof Class ? (Class)type : (type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : null);
        return typeClassClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFieldValue(Object instanceContainingField, String fieldName, Object fieldValue) {
        for (Class<?> targetClass = instanceContainingField.getClass(); targetClass != null; targetClass = targetClass.getSuperclass()) {
            for (Field field : targetClass.getDeclaredFields()) {
                if (!field.getName().equalsIgnoreCase(fieldName)) continue;
                try {
                    boolean isAccessible = field.isAccessible();
                    try {
                        field.setAccessible(true);
                        field.set(instanceContainingField, fieldValue);
                    }
                    finally {
                        field.setAccessible(isAccessible);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to set field [" + fieldName + "] in instance of [" + instanceContainingField.getClass().getName() + "]. The Java Security Manager has " + "probably been configured to prevent settting private field values. XWiki requires " + "this ability to work.", e);
                }
                return;
            }
        }
    }

    public static Class<?> getLastGenericFieldType(Field field) {
        return ReflectionUtils.getTypeClass(ReflectionUtils.getLastFieldGenericArgument(field));
    }

    public static Type getLastFieldGenericArgument(Field field) {
        return ReflectionUtils.getLastTypeGenericArgument(field.getGenericType());
    }

    public static Type getLastTypeGenericArgument(Type type) {
        ParameterizedType pType;
        Type[] types;
        if (type instanceof ParameterizedType && (types = (pType = (ParameterizedType)type).getActualTypeArguments()).length > 0) {
            return types[types.length - 1];
        }
        return null;
    }

    public static Class<?> getLastGenericClassType(Class clazz, Class filterClass) {
        Type[] actualTypes;
        ParameterizedType pType;
        Type type = ReflectionUtils.getGenericClassType(clazz, filterClass);
        if (type instanceof ParameterizedType && filterClass.isAssignableFrom((Class)(pType = (ParameterizedType)type).getRawType()) && (actualTypes = pType.getActualTypeArguments()).length > 0 && actualTypes[actualTypes.length - 1] instanceof Class) {
            return (Class)actualTypes[actualTypes.length - 1];
        }
        return null;
    }

    public static Type getGenericClassType(Class clazz, Class filterClass) {
        for (Type type : clazz.getGenericInterfaces()) {
            ParameterizedType pType;
            if (type == filterClass) {
                return type;
            }
            if (!(type instanceof ParameterizedType) || !filterClass.isAssignableFrom((Class)(pType = (ParameterizedType)type).getRawType())) continue;
            return type;
        }
        return null;
    }

    public static Type[] resolveSuperParameters(Type[] parameters, Class childClass, Type[] childParameters) {
        Type[] actualParameters = null;
        HashMap typeMapping = null;
        for (int i = 0; i < parameters.length; ++i) {
            Type parameter = parameters[i];
            if (parameter instanceof TypeVariable) {
                if (childParameters == null) {
                    return null;
                }
                if (typeMapping == null) {
                    TypeVariable<Class<T>>[] declaredChildParameters = childClass.getTypeParameters();
                    typeMapping = new HashMap();
                    for (int j = 0; j < declaredChildParameters.length; ++j) {
                        typeMapping.put(declaredChildParameters[i], childParameters[i]);
                    }
                }
                if (actualParameters == null) {
                    actualParameters = new Type[parameters.length];
                    for (int j = 0; j < i; ++j) {
                        actualParameters[j] = childParameters[j];
                    }
                }
                actualParameters[i] = (Type)typeMapping.get(parameter);
                continue;
            }
            if (actualParameters == null) continue;
            actualParameters[i] = parameter;
        }
        return actualParameters != null ? actualParameters : parameters;
    }

    public static <T extends Annotation> T getDirectAnnotation(Class<T> annotationClass, AnnotatedElement element) {
        for (Annotation annotation : element.getDeclaredAnnotations()) {
            if (annotation.annotationType() != annotationClass) continue;
            return (T)annotation;
        }
        return null;
    }
}

