/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.internal.asymmetric.keyfactory;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jcajce.provider.asymmetric.dsa.DSAUtil;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.RSAUtil;
import org.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.crypto.AsymmetricKeyFactory;
import org.xwiki.crypto.internal.asymmetric.BcAsymmetricKeyParameters;
import org.xwiki.crypto.internal.asymmetric.keyfactory.AbstractBcKeyFactory;

@Component
@Singleton
public class DefaultKeyFactory
extends AbstractBcKeyFactory {
    @Inject
    private ComponentManager manager;

    @Override
    protected AsymmetricKeyInfoConverter getKeyInfoConverter() {
        throw new UnsupportedOperationException("Unexpected illegal internal call");
    }

    @Override
    protected String checkKeyType(BcAsymmetricKeyParameters key) {
        return null;
    }

    private AsymmetricKeyFactory getKeyFactory(ASN1Object keyInfo) {
        return this.getKeyFactory(this.getKeyFactoryHint(keyInfo));
    }

    private String getKeyFactoryHint(ASN1Object keyInfo) {
        ASN1ObjectIdentifier algId = this.getAlgorithmId(keyInfo);
        String hint = null;
        if (RSAUtil.isRsaOid((ASN1ObjectIdentifier)algId)) {
            hint = "RSA";
        } else if (DSAUtil.isDsaOid((ASN1ObjectIdentifier)algId)) {
            hint = "DSA";
        } else if (algId.equals((ASN1Primitive)PKCSObjectIdentifiers.dhKeyAgreement) || algId.equals((ASN1Primitive)X9ObjectIdentifiers.dhpublicnumber)) {
            hint = "DH";
        } else if (algId.equals((ASN1Primitive)OIWObjectIdentifiers.elGamalAlgorithm)) {
            hint = "ElGamal";
        } else if (algId.equals((ASN1Primitive)CryptoProObjectIdentifiers.gostR3410_94)) {
            hint = "GOST3410";
        }
        if (hint == null) {
            throw new UnsupportedOperationException("Asymmetric key algorithm not supported: " + algId.getId());
        }
        return hint;
    }

    private ASN1ObjectIdentifier getAlgorithmId(ASN1Object keyInfo) {
        if (keyInfo instanceof PrivateKeyInfo) {
            return ((PrivateKeyInfo)keyInfo).getPrivateKeyAlgorithm().getAlgorithm();
        }
        if (keyInfo instanceof SubjectPublicKeyInfo) {
            return ((SubjectPublicKeyInfo)keyInfo).getAlgorithm().getAlgorithm();
        }
        throw new IllegalArgumentException("Asymmetric key expected but received: " + keyInfo.getClass().getName());
    }

    private AsymmetricKeyFactory getKeyFactory(String hint) {
        try {
            return (AsymmetricKeyFactory)this.manager.getInstance(AsymmetricKeyFactory.class, hint);
        }
        catch (ComponentLookupException e) {
            throw new UnsupportedOperationException("Asymmetric key algorithm not found.", e);
        }
    }

    @Override
    public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws IOException {
        AsymmetricKeyFactory factory = this.getKeyFactory((ASN1Object)privateKeyInfo);
        if (factory instanceof AsymmetricKeyInfoConverter) {
            return ((AsymmetricKeyInfoConverter)factory).generatePrivate(privateKeyInfo);
        }
        return factory.toKey(this.fromPKCS8(privateKeyInfo.getEncoded()));
    }

    @Override
    public PublicKey generatePublic(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        AsymmetricKeyFactory factory = this.getKeyFactory((ASN1Object)publicKeyInfo);
        if (factory instanceof AsymmetricKeyInfoConverter) {
            return ((AsymmetricKeyInfoConverter)factory).generatePublic(publicKeyInfo);
        }
        return factory.toKey(this.fromX509(publicKeyInfo.getEncoded()));
    }
}

