/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.internal.digest.factory;

import javax.inject.Named;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.Digest;
import org.xwiki.crypto.internal.digest.BouncyCastleDigest;
import org.xwiki.crypto.internal.digest.factory.BcDigestFactory;
import org.xwiki.crypto.params.DigestParameters;

public abstract class AbstractBcDigestFactory
implements BcDigestFactory {
    @Override
    public String getDigestAlgorithmName() {
        String hint = null;
        Named named = this.getClass().getAnnotation(Named.class);
        if (named != null) {
            hint = named.value();
        } else {
            Component component = this.getClass().getAnnotation(Component.class);
            if (component != null && component.hints().length > 0) {
                hint = component.hints()[0];
            }
        }
        return hint;
    }

    @Override
    public int getDigestSize() {
        return this.getDigestInstance().getDigestSize();
    }

    @Override
    public Digest getInstance() {
        return new BouncyCastleDigest(this.getDigestInstance(), this.getAlgorithmIdentifier(), null);
    }

    @Override
    public Digest getInstance(DigestParameters parameters) {
        return this.getInstance();
    }

    @Override
    public Digest getInstance(byte[] encoded) {
        AlgorithmIdentifier algId = AlgorithmIdentifier.getInstance((Object)encoded);
        if (!algId.getAlgorithm().equals((ASN1Primitive)this.getAlgorithmIdentifier().getAlgorithm())) {
            throw new IllegalArgumentException("Invalid algorithm identifier in encoded data for this digest factory: " + algId.getAlgorithm().getId());
        }
        return this.getInstance();
    }
}

