/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.internal.encoder;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xwiki.crypto.BinaryStringEncoder;
import org.xwiki.crypto.internal.LineWrapperOutputStream;
import org.xwiki.crypto.internal.encoder.BcBinaryStringEncoderInputStream;
import org.xwiki.crypto.internal.encoder.BcBinaryStringEncoderOutputStream;
import org.xwiki.crypto.internal.encoder.InternalBinaryStringEncoder;

public abstract class AbstractBinaryStringEncoder
implements BinaryStringEncoder {
    private static final String CHARSET = "UTF-8";

    abstract InternalBinaryStringEncoder getEncoder();

    @Override
    public String encode(byte[] input) throws IOException {
        return this.encode(input, 0, input.length);
    }

    @Override
    public String encode(byte[] input, int wrapAt) throws IOException {
        return this.encode(input, 0, input.length, wrapAt);
    }

    @Override
    public String encode(byte[] input, int off, int len) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.getEncoder().encode(input, off, len, baos);
        baos.close();
        return baos.toString(CHARSET);
    }

    @Override
    public String encode(byte[] input, int off, int len, int wrapAt) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        LineWrapperOutputStream lwos = new LineWrapperOutputStream(baos, wrapAt);
        this.getEncoder().encode(input, off, len, lwos);
        lwos.close();
        return baos.toString(CHARSET);
    }

    @Override
    public byte[] decode(String input) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] inBytes = input.getBytes();
        this.getEncoder().decode(inBytes, 0, inBytes.length, baos);
        baos.close();
        return baos.toByteArray();
    }

    @Override
    public FilterInputStream getDecoderInputStream(InputStream is) {
        return new BcBinaryStringEncoderInputStream(is, this.getEncoder());
    }

    @Override
    public FilterOutputStream getEncoderOutputStream(OutputStream os) {
        return new BcBinaryStringEncoderOutputStream(os, this.getEncoder());
    }

    @Override
    public FilterOutputStream getEncoderOutputStream(OutputStream os, int wrapAt) {
        return new BcBinaryStringEncoderOutputStream(new LineWrapperOutputStream(os, wrapAt), this.getEncoder());
    }
}

