/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.internal.asymmetric.generator;

import java.security.SecureRandom;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.DSAKeyPairGenerator;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAValidationParameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.AsymmetricKeyFactory;
import org.xwiki.crypto.KeyParametersGenerator;
import org.xwiki.crypto.internal.asymmetric.generator.AbstractBcKeyPairGenerator;
import org.xwiki.crypto.internal.asymmetric.generator.BcDSAKeyParameterGenerator;
import org.xwiki.crypto.params.cipher.asymmetric.AsymmetricKeyPair;
import org.xwiki.crypto.params.generator.asymmetric.DSAKeyGenerationParameters;
import org.xwiki.crypto.params.generator.asymmetric.DSAKeyParametersGenerationParameters;
import org.xwiki.crypto.params.generator.asymmetric.DSAKeyValidationParameters;

@Component
@Singleton
@Named(value="DSA")
public class BcDSAKeyPairGenerator
extends AbstractBcKeyPairGenerator {
    @Inject
    @Named(value="DSA")
    private AsymmetricKeyFactory factory;
    @Inject
    @Named(value="DSA")
    private KeyParametersGenerator parametersGenerator;
    @Inject
    private Provider<SecureRandom> random;

    @Override
    protected AsymmetricKeyFactory getFactory() {
        return this.factory;
    }

    @Override
    public AsymmetricKeyPair generate() {
        return this.generate(new DSAKeyParametersGenerationParameters());
    }

    @Override
    public AsymmetricKeyPair generate(org.xwiki.crypto.params.generator.KeyGenerationParameters parameters) {
        DSAParameters keyGenParams;
        if (parameters instanceof DSAKeyParametersGenerationParameters) {
            keyGenParams = this.getDsaParameters((DSAKeyGenerationParameters)this.parametersGenerator.generate((DSAKeyParametersGenerationParameters)parameters));
        } else if (parameters instanceof DSAKeyGenerationParameters) {
            keyGenParams = this.getDsaParameters((DSAKeyGenerationParameters)parameters);
        } else {
            throw new IllegalArgumentException("Invalid parameters for DSA key generator: " + parameters.getClass().getName());
        }
        DSAKeyPairGenerator generator = new DSAKeyPairGenerator();
        generator.init((KeyGenerationParameters)new org.bouncycastle.crypto.params.DSAKeyGenerationParameters((SecureRandom)this.random.get(), keyGenParams));
        return this.getKeyPair(generator.generateKeyPair());
    }

    private DSAParameters getDsaParameters(DSAKeyGenerationParameters parameters) {
        DSAKeyValidationParameters dsaValidParams = parameters.getValidationParameters();
        return new DSAParameters(parameters.getP(), parameters.getQ(), parameters.getG(), dsaValidParams != null ? new DSAValidationParameters(dsaValidParams.getSeed(), dsaValidParams.getCounter(), BcDSAKeyParameterGenerator.getUsageIndex(dsaValidParams.getUsage())) : null);
    }
}

