/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.password.internal.pbe;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.xwiki.crypto.cipher.Cipher;
import org.xwiki.crypto.params.cipher.symmetric.SymmetricCipherParameters;
import org.xwiki.crypto.password.KeyDerivationFunction;
import org.xwiki.crypto.password.internal.kdf.AbstractBcKDF;
import org.xwiki.crypto.password.internal.kdf.PBES2Parameters;
import org.xwiki.crypto.password.internal.pbe.AbstractBcPBCipher;

public abstract class AbstractBcPBES2Cipher
extends AbstractBcPBCipher {
    public AbstractBcPBES2Cipher(Cipher cipher, KeyDerivationFunction kdf, SymmetricCipherParameters parameters) {
        super(cipher, kdf, parameters);
    }

    protected abstract EncryptionScheme getScheme(SymmetricCipherParameters var1);

    @Override
    public AlgorithmIdentifier getPBEParameters() throws IOException {
        KeyDerivationFunc kdfParams = this.getKeyDerivationFunction() instanceof AbstractBcKDF ? ((AbstractBcKDF)this.getKeyDerivationFunction()).getKeyDerivationFunction() : KeyDerivationFunc.getInstance((Object)this.getKeyDerivationFunction().getEncoded());
        EncryptionScheme scheme = this.getScheme(this.getParameters());
        return new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, (ASN1Encodable)new PBES2Parameters(kdfParams, scheme));
    }
}

