/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.password.internal.kdf;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.crypto.generators.SCrypt;
import org.xwiki.crypto.params.cipher.symmetric.KeyParameter;
import org.xwiki.crypto.params.cipher.symmetric.KeyWithIVParameters;
import org.xwiki.crypto.password.internal.kdf.AbstractBcKDF;
import org.xwiki.crypto.password.internal.kdf.ScryptKDFParams;
import org.xwiki.crypto.password.params.KeyDerivationFunctionParameters;
import org.xwiki.crypto.password.params.ScryptParameters;

public class BcScryptKDF
extends AbstractBcKDF {
    private static final ASN1ObjectIdentifier ALG_ID = new ASN1ObjectIdentifier("1.3.6.1.4.1.11591.4.11");
    protected final ScryptParameters parameters;

    public BcScryptKDF(ScryptParameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public KeyDerivationFunc getKeyDerivationFunction() {
        return new KeyDerivationFunc(ALG_ID, (ASN1Encodable)new ScryptKDFParams(this.parameters.getSalt(), this.parameters.getCostParameter(), this.parameters.getBlockSize(), this.parameters.getParallelizationParameter(), this.parameters.getKeySize()));
    }

    @Override
    public KeyDerivationFunctionParameters getParameters() {
        return this.parameters;
    }

    @Override
    public KeyParameter derive(byte[] password) {
        return new KeyParameter(SCrypt.generate((byte[])password, (byte[])this.parameters.getSalt(), (int)this.parameters.getCostParameter(), (int)this.parameters.getBlockSize(), (int)this.parameters.getParallelizationParameter(), (int)this.getKeySize()));
    }

    @Override
    public KeyWithIVParameters derive(byte[] password, int ivSize) {
        int keySize = this.getKeySize();
        byte[] keyIV = SCrypt.generate((byte[])password, (byte[])this.parameters.getSalt(), (int)this.parameters.getCostParameter(), (int)this.parameters.getBlockSize(), (int)this.parameters.getParallelizationParameter(), (int)(keySize + ivSize));
        byte[] key = new byte[keySize];
        System.arraycopy(keyIV, 0, key, 0, keySize);
        byte[] iv = new byte[ivSize];
        System.arraycopy(keyIV, keySize, iv, 0, ivSize);
        return new KeyWithIVParameters(key, iv);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.getKeyDerivationFunction().getEncoded();
    }
}

