/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.password.internal.kdf;

import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class PBKDF2Params
extends ASN1Object {
    private final ASN1OctetString octStr;
    private final ASN1Integer iterationCount;
    private final ASN1Integer keyLength;
    private final AlgorithmIdentifier prf;

    public PBKDF2Params(byte[] salt, int iterationCount) {
        this((ASN1OctetString)new DEROctetString(salt), new ASN1Integer((long)iterationCount), null, null);
    }

    public PBKDF2Params(byte[] salt, int iterationCount, AlgorithmIdentifier prf) {
        this((ASN1OctetString)new DEROctetString(salt), new ASN1Integer((long)iterationCount), null, prf);
    }

    public PBKDF2Params(byte[] salt, int iterationCount, int keyLength) {
        this((ASN1OctetString)new DEROctetString(salt), new ASN1Integer((long)iterationCount), new ASN1Integer((long)keyLength), null);
    }

    public PBKDF2Params(byte[] salt, int iterationCount, int keyLength, AlgorithmIdentifier prf) {
        this((ASN1OctetString)new DEROctetString(salt), new ASN1Integer((long)iterationCount), new ASN1Integer((long)keyLength), prf);
    }

    private PBKDF2Params(ASN1OctetString salt, ASN1Integer iterationCount, ASN1Integer keyLength, AlgorithmIdentifier prf) {
        this.octStr = salt;
        this.iterationCount = iterationCount;
        this.keyLength = keyLength;
        this.prf = prf;
    }

    private PBKDF2Params(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.octStr = (ASN1OctetString)e.nextElement();
        this.iterationCount = (ASN1Integer)e.nextElement();
        if (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (obj instanceof ASN1Integer) {
                this.keyLength = (ASN1Integer)obj;
                this.prf = e.hasMoreElements() ? AlgorithmIdentifier.getInstance(obj) : null;
            } else {
                this.keyLength = null;
                this.prf = AlgorithmIdentifier.getInstance(obj);
            }
        } else {
            this.keyLength = null;
            this.prf = null;
        }
    }

    public static PBKDF2Params getInstance(Object obj) {
        if (obj instanceof PBKDF2Params) {
            return (PBKDF2Params)((Object)obj);
        }
        if (obj instanceof org.bouncycastle.asn1.pkcs.PBKDF2Params) {
            org.bouncycastle.asn1.pkcs.PBKDF2Params params = (org.bouncycastle.asn1.pkcs.PBKDF2Params)obj;
            if (params.getKeyLength() != null) {
                return new PBKDF2Params(params.getSalt(), params.getIterationCount().intValue(), params.getKeyLength().intValue());
            }
            return new PBKDF2Params(params.getSalt(), params.getIterationCount().intValue());
        }
        if (obj != null) {
            return new PBKDF2Params(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }

    public byte[] getSalt() {
        return this.octStr.getOctets();
    }

    public BigInteger getIterationCount() {
        return this.iterationCount.getValue();
    }

    public BigInteger getKeyLength() {
        if (this.keyLength != null) {
            return this.keyLength.getValue();
        }
        return null;
    }

    public AlgorithmIdentifier getPseudoRandomFunctionIdentifier() {
        return this.prf;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.octStr);
        v.add((ASN1Encodable)this.iterationCount);
        if (this.keyLength != null) {
            v.add((ASN1Encodable)this.keyLength);
        }
        if (this.prf != null) {
            v.add((ASN1Encodable)this.prf);
        }
        return new DERSequence(v);
    }
}

