/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.password.internal.pbe.factory;

import javax.inject.Inject;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.xwiki.crypto.cipher.CipherFactory;
import org.xwiki.crypto.params.cipher.symmetric.SymmetricCipherParameters;
import org.xwiki.crypto.password.KeyDerivationFunctionFactory;
import org.xwiki.crypto.password.PasswordBasedCipher;
import org.xwiki.crypto.password.PasswordBasedCipherFactory;
import org.xwiki.crypto.password.params.KeyDerivationFunctionParameters;

public abstract class AbstractBcPBCipherFactory
implements PasswordBasedCipherFactory {
    private static final RuntimeException UNSUPPORTED = new UnsupportedOperationException("Sorry, this factory does implement any concrete cipher.");
    @Inject
    private KeyDerivationFunctionFactory kdfFactory;

    protected KeyDerivationFunctionFactory getKDFFactory() {
        return this.kdfFactory;
    }

    private CipherFactory safeGetCipherFactory() {
        try {
            return this.getCipherFactory();
        }
        catch (UnsupportedOperationException e) {
            throw UNSUPPORTED;
        }
    }

    public String getCipherAlgorithmName() {
        return this.safeGetCipherFactory().getCipherAlgorithmName();
    }

    public int getIVSize() {
        return this.safeGetCipherFactory().getIVSize();
    }

    public int getKeySize() {
        return this.safeGetCipherFactory().getKeySize();
    }

    public int[] getSupportedKeySizes() {
        return this.safeGetCipherFactory().getSupportedKeySizes();
    }

    public boolean isSupportedKeySize(int keySize) {
        return this.safeGetCipherFactory().isSupportedKeySize(keySize);
    }

    @Override
    public PasswordBasedCipher getInstance(boolean forEncryption, SymmetricCipherParameters password, KeyDerivationFunctionParameters parameters) {
        throw new UnsupportedOperationException("Sorry, no concrete implementation to create an instance.");
    }

    @Override
    public PasswordBasedCipher getInstance(boolean forEncryption, byte[] password, byte[] encoded) {
        return this.getInstance(forEncryption, password, (ASN1Encodable)ASN1Sequence.getInstance((Object)encoded));
    }

    protected abstract CipherFactory getCipherFactory();

    public abstract PasswordBasedCipher getInstance(boolean var1, byte[] var2, ASN1Encodable var3);
}

