/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.password.internal.pbe.factory;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.cipher.CipherFactory;
import org.xwiki.crypto.params.cipher.CipherParameters;
import org.xwiki.crypto.params.cipher.symmetric.KeyWithIVParameters;
import org.xwiki.crypto.params.cipher.symmetric.SymmetricCipherParameters;
import org.xwiki.crypto.password.KeyDerivationFunction;
import org.xwiki.crypto.password.PasswordBasedCipher;
import org.xwiki.crypto.password.internal.pbe.AbstractBcPBES2Cipher;
import org.xwiki.crypto.password.internal.pbe.factory.AbstractBcPBES2CipherFactory;

@Component(hints={"PBES2-DES-Pad", "1.3.14.3.2.7"})
@Singleton
public class BcPBES2DesCipherFactory
extends AbstractBcPBES2CipherFactory {
    private static final ASN1ObjectIdentifier ALG_ID = new ASN1ObjectIdentifier("1.3.14.3.2.7");
    @Inject
    @Named(value="DES/CBC/PKCS5Padding")
    private CipherFactory cipherFactory;

    @Override
    protected CipherFactory getCipherFactory() {
        return this.cipherFactory;
    }

    @Override
    protected PasswordBasedCipher getPasswordBasedCipher(boolean forEncryption, KeyDerivationFunction kdf, SymmetricCipherParameters params) {
        return new AbstractBcPBES2Cipher(this.getCipherFactory().getInstance(forEncryption, (CipherParameters)params), kdf, params){

            @Override
            protected EncryptionScheme getScheme(SymmetricCipherParameters parameters) {
                return new EncryptionScheme(ALG_ID, (ASN1Encodable)new DEROctetString(((KeyWithIVParameters)parameters).getIV()));
            }
        };
    }
}

