/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix.params.x509certificate;

import java.io.IOException;
import org.bouncycastle.asn1.x500.X500Name;
import org.xwiki.crypto.pkix.internal.BcPrincipalIdentifier;
import org.xwiki.crypto.pkix.params.PrincipalIndentifier;
import org.xwiki.stability.Unstable;

@Unstable
public class DistinguishedName
implements PrincipalIndentifier,
BcPrincipalIdentifier {
    private final X500Name dn;

    public DistinguishedName(Object name) {
        this.dn = name instanceof String ? new X500Name((String)name) : X500Name.getInstance((Object)name);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.dn.getEncoded();
    }

    @Override
    public String getName() {
        return this.dn.toString();
    }

    @Override
    public X500Name getX500Name() {
        return this.dn;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrincipalIndentifier)) {
            return false;
        }
        X500Name name = o instanceof BcPrincipalIdentifier ? ((BcPrincipalIdentifier)o).getX500Name() : new X500Name(((PrincipalIndentifier)o).getName());
        return this.dn.equals((Object)name);
    }

    public int hashCode() {
        return this.dn.hashCode();
    }
}

