/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix.params.x509certificate.extension;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.GeneralName;
import org.xwiki.crypto.pkix.internal.extension.BcGeneralName;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509StringGeneralName;

public class X509IpAddress
implements X509StringGeneralName,
BcGeneralName {
    private final byte[] ipAddress;

    public X509IpAddress(String ipAddress) {
        GeneralName name = new GeneralName(7, ipAddress);
        this.ipAddress = DEROctetString.getInstance((Object)name.getName()).getOctets();
    }

    public X509IpAddress(InetAddress ipAddress) {
        this.ipAddress = ipAddress.getAddress();
    }

    public X509IpAddress(InetAddress ipAddress, InetAddress ipMask) {
        byte[] ip = ipAddress.getAddress();
        byte[] mask = ipMask.getAddress();
        if (ip.length != mask.length) {
            throw new IllegalArgumentException("Incompatible ip address (" + ip.length + ") and ip mask (" + mask.length + ")");
        }
        this.ipAddress = new byte[ip.length + mask.length];
        System.arraycopy(ip, 0, this.ipAddress, 0, ip.length);
        System.arraycopy(mask, 0, this.ipAddress, ip.length, mask.length);
    }

    public X509IpAddress(GeneralName name) {
        if (name.getTagNo() != 7) {
            throw new IllegalArgumentException("Incompatible general name: " + name.getTagNo());
        }
        this.ipAddress = DEROctetString.getInstance((Object)name.getName()).getOctets();
    }

    public InetAddress getIpAddress() throws UnknownHostException {
        byte[] ip = this.ipAddress;
        if (ip.length == 8 || ip.length == 32) {
            ip = new byte[ip.length / 2];
            System.arraycopy(this.ipAddress, 0, ip, 0, ip.length);
        }
        return InetAddress.getByAddress(ip);
    }

    public InetAddress getIpMask() throws UnknownHostException {
        if (this.ipAddress.length != 8 && this.ipAddress.length != 32) {
            return null;
        }
        byte[] mask = new byte[this.ipAddress.length / 2];
        System.arraycopy(this.ipAddress, mask.length, mask, 0, mask.length);
        return InetAddress.getByAddress(mask);
    }

    @Override
    public String getName() {
        try {
            if (this.ipAddress.length != 8 && this.ipAddress.length != 32) {
                return this.getIpAddress().getHostAddress();
            }
            return this.getIpAddress().getHostAddress() + "/" + this.getIpMask().getHostAddress();
        }
        catch (UnknownHostException e) {
            return Arrays.toString(this.ipAddress);
        }
    }

    @Override
    public GeneralName getGeneralName() {
        return new GeneralName(7, (ASN1Encodable)new DEROctetString(this.ipAddress));
    }
}

