/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.signer.internal.factory;

import javax.inject.Singleton;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.params.cipher.asymmetric.AsymmetricCipherParameters;
import org.xwiki.crypto.signer.internal.factory.AbstractBcSignerFactory;

@Component(hints={"SHA512withRSAEncryption", "1.2.840.113549.1.1.13"})
@Singleton
public class BcSHA512withRsaSignerFactory
extends AbstractBcSignerFactory {
    private static final AlgorithmIdentifier ALG_ID = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha512WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE);

    @Override
    protected Signer getSignerInstance(AsymmetricCipherParameters parameters) {
        return new RSADigestSigner((Digest)new SHA512Digest());
    }

    @Override
    protected AlgorithmIdentifier getSignerAlgorithmIdentifier(AsymmetricCipherParameters parameters) {
        return ALG_ID;
    }
}

