/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.environment.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.environment.internal.AbstractEnvironment;

@Component
@Singleton
public class StandardEnvironment
extends AbstractEnvironment {
    private File resourceDirectory;
    private ClassLoader resourceClassLoader = StandardEnvironment.class.getClassLoader();

    public void setResourceDirectory(File resourceDirectory) {
        this.resourceDirectory = resourceDirectory;
    }

    public void setResourceClassLoader(ClassLoader classLoader) {
        this.resourceClassLoader = classLoader;
    }

    public InputStream getResourceAsStream(String resourceName) {
        InputStream resourceStream = null;
        URL resourceURL = this.getResource(resourceName);
        if (resourceURL != null) {
            try {
                resourceStream = resourceURL.openStream();
            }
            catch (IOException e) {
                this.logger.debug("Failed to get Input stream for resource [{}]", (Object)resourceName, (Object)e);
            }
        }
        return resourceStream;
    }

    public URL getResource(String resourceName) {
        URL resourceURL = null;
        if (this.resourceDirectory != null) {
            try {
                File resourceFile = new File(this.resourceDirectory, resourceName);
                if (resourceFile.exists()) {
                    resourceURL = resourceFile.toURI().toURL();
                }
            }
            catch (MalformedURLException e) {
                this.logger.debug("Failed to access resource [{}]", (Object)resourceName, (Object)e);
            }
        }
        if (resourceURL == null) {
            resourceURL = this.resourceClassLoader.getResource(resourceName);
        }
        return resourceURL;
    }
}

