/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionNotFoundException;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.AbstractExtensionRepository;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.internal.ExtensionSerializer;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtension;
import org.xwiki.extension.repository.result.CollectionIterableResult;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.test.FileExtension;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.internal.DefaultVersion;

public class FileExtensionRepository
extends AbstractExtensionRepository
implements ExtensionRepository {
    private ExtensionSerializer extensionSerializer;
    private File directory;

    public FileExtensionRepository(File directory, ComponentManager componentManager) throws ComponentLookupException {
        super((ExtensionRepositoryDescriptor)new DefaultExtensionRepositoryDescriptor("test-file", "file", null));
        this.extensionSerializer = (ExtensionSerializer)componentManager.getInstance(ExtensionSerializer.class);
        this.directory = directory;
    }

    public File getDirectory() {
        return this.directory;
    }

    InputStream getFileAsStream(ExtensionId extensionId, String type) throws FileNotFoundException, UnsupportedEncodingException {
        return new FileInputStream(this.getFile(extensionId, type));
    }

    public File getFile(ExtensionId extensionId, String type) throws UnsupportedEncodingException {
        File extensionFile = new File(this.directory, this.getEncodedPath(extensionId, type));
        return extensionFile;
    }

    String getEncodedPath(ExtensionId extensionId, String type) throws UnsupportedEncodingException {
        return URLEncoder.encode(this.getPathSuffix(extensionId, type), "UTF-8");
    }

    String getPathSuffix(ExtensionId extensionId, String type) {
        return extensionId.getId() + '-' + extensionId.getVersion().getValue() + '.' + type;
    }

    public Extension resolve(ExtensionId extensionId) throws ResolveException {
        InputStream descriptor;
        try {
            descriptor = this.getFileAsStream(extensionId, "xed");
        }
        catch (FileNotFoundException e) {
            throw new ExtensionNotFoundException("Could not find extension [" + extensionId + "]", (Throwable)e);
        }
        catch (Exception e) {
            throw new ResolveException("Invalid extension id [" + extensionId + "]", (Throwable)e);
        }
        if (descriptor == null) {
            throw new ExtensionNotFoundException("Extension [" + extensionId + "] not found");
        }
        try {
            DefaultLocalExtension localExtension = this.extensionSerializer.loadLocalExtensionDescriptor(null, descriptor);
            return new FileExtension(this, (Extension)localExtension);
        }
        catch (Exception e) {
            throw new ResolveException("Failed to parse descriptor for extension [" + extensionId + "]", (Throwable)e);
        }
    }

    public Extension resolve(ExtensionDependency extensionDependency) throws ResolveException {
        VersionConstraint versionConstraint = extensionDependency.getVersionConstraint();
        if (versionConstraint.getVersion() != null) {
            return this.resolve(new ExtensionId(extensionDependency.getId(), (Version)new DefaultVersion(extensionDependency.getVersionConstraint().getValue())));
        }
        List<Version> versions = this.getVersions(extensionDependency.getId());
        if (!versions.isEmpty()) {
            ListIterator<Version> it = versions.listIterator(versions.size());
            while (it.hasPrevious()) {
                Version version = it.previous();
                if (versionConstraint.isCompatible(version)) {
                    return this.resolve(new ExtensionId(extensionDependency.getId(), version));
                }
                it.previous();
            }
        }
        throw new ExtensionNotFoundException("Extension dependency [" + extensionDependency + "] not found");
    }

    public boolean exists(ExtensionId extensionId) {
        try {
            return this.getFile(extensionId, "xed").exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Version> getVersions(final String id) throws ResolveException {
        LinkedList<Version> versions = new LinkedList<Version>();
        try {
            for (File file : this.directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(id + '-') && name.endsWith(".xed");
                }
            })) {
                try (FileInputStream fis = null;){
                    fis = new FileInputStream(file);
                    DefaultLocalExtension localExtension = this.extensionSerializer.loadLocalExtensionDescriptor(null, (InputStream)fis);
                    if (!localExtension.getId().getId().equals(id)) continue;
                    versions.add(localExtension.getId().getVersion());
                }
            }
        }
        catch (Exception e) {
            throw new ResolveException("Failed to resolve versions for extenion [" + id + "]", (Throwable)e);
        }
        Collections.sort(versions);
        return versions;
    }

    public IterableResult<Version> resolveVersions(String id, int offset, int nb) throws ResolveException {
        List<Version> versions = this.getVersions(id);
        if (versions.isEmpty()) {
            throw new ExtensionNotFoundException("Extension [" + id + "] not found");
        }
        return new CollectionIterableResult(0, offset, versions);
    }
}

