/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionPattern;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.stability.Unstable;

public interface ExtensionDependency {
    public String getId();

    public VersionConstraint getVersionConstraint();

    @Unstable
    default public Collection<ExtensionPattern> getExclusions() {
        return Collections.emptyList();
    }

    public Collection<ExtensionRepositoryDescriptor> getRepositories();

    public Map<String, Object> getProperties();

    public Object getProperty(String var1);

    public <T> T getProperty(String var1, T var2);

    default public boolean isCompatible(Extension extension) {
        if (this.isCompatible(extension.getId())) {
            return true;
        }
        for (ExtensionId extensionId : extension.getExtensionFeatures()) {
            if (!this.isCompatible(extensionId)) continue;
            return true;
        }
        return false;
    }

    default public boolean isCompatible(ExtensionId extensionId) {
        return this.getId().equals(extensionId.getId()) && this.getVersionConstraint().isCompatible(extensionId.getVersion());
    }

    default public boolean isOptional() {
        return false;
    }
}

