/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.extension.internal.converter.ExtensionIdConverter;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.internal.DefaultVersion;

public class ExtensionId
implements Serializable,
Comparable<ExtensionId> {
    public static final ParameterizedType TYPE_LIST = new DefaultParameterizedType(null, List.class, new Type[]{ExtensionId.class});
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Version version;
    private transient int hashCode;

    public ExtensionId(String id) {
        this(id, (Version)null);
    }

    public ExtensionId(String id, String version) {
        this(id, version != null ? new DefaultVersion(version) : null);
    }

    public ExtensionId(String id, Version version) {
        this.id = id;
        this.version = version;
    }

    public String getId() {
        return this.id;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExtensionId) {
            ExtensionId extensionId = (ExtensionId)obj;
            return Objects.equals(extensionId.getId(), this.getId()) && Objects.equals(extensionId.getVersion(), this.getVersion());
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeBuilder builder = new HashCodeBuilder();
            builder.append((Object)this.getId());
            builder.append((Object)this.getVersion());
            this.hashCode = builder.toHashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return ExtensionIdConverter.toString(this);
    }

    @Override
    public int compareTo(ExtensionId o) {
        if (o == null) {
            return -1;
        }
        CompareToBuilder builder = new CompareToBuilder();
        builder.append((Object)this.getId(), (Object)o.getId());
        builder.append((Object)this.getVersion(), (Object)o.getVersion());
        return builder.toComparison();
    }

    public boolean matches(ExtensionId extensionId) {
        return Objects.equals(this.getId(), extensionId.getId()) && (this.getVersion() == null || extensionId.getVersion() == null || Objects.equals(this.getVersion(), extensionId.getVersion()));
    }

    public boolean matchesOne(Iterable<ExtensionId> extensionIds) {
        for (ExtensionId extensionId : extensionIds) {
            if (!this.matches(extensionId)) continue;
            return true;
        }
        return false;
    }
}

