/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.history.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.job.history.ExtensionJobHistoryRecord;
import org.xwiki.extension.job.history.ExtensionJobHistorySerializer;
import org.xwiki.extension.job.history.internal.CompositeReader;
import org.xwiki.xstream.internal.SafeXStream;

@Component
@Singleton
public class DefaultExtensionJobHistorySerializer
implements ExtensionJobHistorySerializer {
    @Inject
    private SafeXStream xstream;

    @Override
    public String serialize(ExtensionJobHistoryRecord record) {
        return this.xstream.toXML((Object)record);
    }

    @Override
    public void write(ExtensionJobHistoryRecord record, Writer writer) {
        this.xstream.toXML((Object)record, writer);
    }

    @Override
    public void append(ExtensionJobHistoryRecord record, File historyFile) throws IOException {
        historyFile.getParentFile().mkdirs();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(historyFile, true));){
            this.write(record, writer);
        }
    }

    @Override
    public List<ExtensionJobHistoryRecord> deserialize(String serializedRecords) {
        return this.read(new StringReader(serializedRecords));
    }

    @Override
    public List<ExtensionJobHistoryRecord> read(Reader reader) {
        CompositeReader listReader = new CompositeReader(new StringReader("<list>"), reader, new StringReader("</list>"));
        return (List)this.xstream.fromXML((Reader)listReader);
    }

    @Override
    public List<ExtensionJobHistoryRecord> read(File historyFile) throws IOException {
        try (FileReader reader = new FileReader(historyFile);){
            List<ExtensionJobHistoryRecord> list = this.read(reader);
            return list;
        }
    }

    @Override
    public List<ExtensionJobHistoryRecord> clone(List<ExtensionJobHistoryRecord> records) {
        return this.deserialize(this.xstream.toXML(records));
    }
}

