/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.handler.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.handler.ExtensionHandlerManager;
import org.xwiki.extension.handler.ExtensionInitializer;
import org.xwiki.extension.job.internal.ExtensionPlanContext;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.InstalledExtensionRepository;

@Component
@Singleton
public class DefaultExtensionInitializer
implements ExtensionInitializer,
Initializable {
    @Inject
    private InstalledExtensionRepository installedExtensionRepository;
    @Inject
    private ExtensionHandlerManager extensionHandlerManager;
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private Logger logger;

    @Override
    public void initialize() {
        this.initialize(null, null);
    }

    @Override
    public void initialize(String namespaceToLoad) {
        this.initialize(namespaceToLoad, null);
    }

    @Override
    public void initialize(String namespaceToInitialize, String type) {
        HashMap<String, Map<InstalledExtension, Boolean>> initializedExtensions = new HashMap<String, Map<InstalledExtension, Boolean>>();
        Collection<InstalledExtension> installedExtensions = namespaceToInitialize != null ? this.installedExtensionRepository.getInstalledExtensions(namespaceToInitialize) : this.installedExtensionRepository.getInstalledExtensions();
        for (InstalledExtension installedExtension : installedExtensions) {
            if (type != null && !type.equals(installedExtension.getType())) continue;
            try {
                this.initializeExtension(installedExtension, namespaceToInitialize, initializedExtensions);
            }
            catch (Throwable t) {
                this.logger.error("Failed to initialize local extension [{}]", (Object)installedExtension.getId(), (Object)t);
            }
        }
    }

    private void initializeExtension(InstalledExtension installedExtension, String namespaceToLoad, Map<String, Map<InstalledExtension, Boolean>> initializedExtensions) throws ExtensionException {
        if (installedExtension.getNamespaces() != null) {
            if (namespaceToLoad == null) {
                for (String namespace : installedExtension.getNamespaces()) {
                    this.initializeExtensionInNamespace(installedExtension, namespace, initializedExtensions, new ExtensionPlanContext());
                }
            } else if (installedExtension.getNamespaces().contains(namespaceToLoad)) {
                this.initializeExtensionInNamespace(installedExtension, namespaceToLoad, initializedExtensions, new ExtensionPlanContext());
            }
        } else if (namespaceToLoad == null) {
            this.initializeExtensionInNamespace(installedExtension, null, initializedExtensions, new ExtensionPlanContext());
        }
    }

    private boolean initializeExtensionInNamespace(InstalledExtension installedExtension, String namespace, Map<String, Map<InstalledExtension, Boolean>> initializedExtensions, ExtensionPlanContext extensionContext) throws ExtensionException {
        Boolean initialized;
        if (!installedExtension.isValid(namespace)) {
            return false;
        }
        Map<InstalledExtension, Boolean> initializedExtensionsInNamespace = initializedExtensions.get(namespace);
        if (initializedExtensionsInNamespace == null) {
            initializedExtensionsInNamespace = new HashMap<InstalledExtension, Boolean>();
            initializedExtensions.put(namespace, initializedExtensionsInNamespace);
        }
        if ((initialized = initializedExtensionsInNamespace.get(installedExtension)) == null) {
            initialized = this.initializeExtensionInNamespace(installedExtension, namespace, initializedExtensions, initializedExtensionsInNamespace, extensionContext);
        }
        return initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initializeExtensionInNamespace(InstalledExtension installedExtension, String namespace, Map<String, Map<InstalledExtension, Boolean>> initializedExtensions, Map<InstalledExtension, Boolean> initializedExtensionsInNamespace, ExtensionPlanContext extensionContext) throws ExtensionException {
        if (namespace != null && installedExtension.getNamespaces() == null) {
            return this.initializeExtensionInNamespace(installedExtension, null, initializedExtensions, extensionContext);
        }
        boolean intialized = false;
        try {
            for (ExtensionDependency dependency : installedExtension.getDependencies()) {
                this.initializeExtensionDependencyInNamespace(installedExtension, dependency, namespace, initializedExtensions, new ExtensionPlanContext(extensionContext, installedExtension));
            }
            this.extensionHandlerManager.initialize(installedExtension, namespace);
            intialized = true;
        }
        finally {
            initializedExtensionsInNamespace.put(installedExtension, intialized);
        }
        return intialized;
    }

    private void initializeExtensionDependencyInNamespace(InstalledExtension installedExtension, ExtensionDependency dependency, String namespace, Map<String, Map<InstalledExtension, Boolean>> initializedExtensions, ExtensionPlanContext extensionContext) throws ExtensionException {
        InstalledExtension dependencyExtension;
        if (!this.coreExtensionRepository.exists(dependency.getId()) && (dependencyExtension = this.installedExtensionRepository.getInstalledExtension(dependency.getId(), namespace)) != null) {
            if (dependencyExtension == installedExtension) {
                throw new ExtensionException(String.format("Extension [%s] has itself as a dependency ([%s]). It usually means an extension is installed along with one of its features.", installedExtension, dependency));
            }
            try {
                if (!this.initializeExtensionInNamespace(dependencyExtension, namespace, initializedExtensions, new ExtensionPlanContext(extensionContext, dependency))) {
                    throw new ExtensionException(String.format("Extension [%s] cannot be initialized because its dependency ([%s]) could not.", installedExtension, dependency));
                }
            }
            catch (Throwable e) {
                if (dependency.isOptional()) {
                    this.logger.warn("Failed to initialize dependency [{}]: {}", (Object)dependency, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
                throw new ExtensionException(String.format("Failed to initialize dependency [%s]", dependency), e);
            }
        }
    }
}

