/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.history.internal;

import java.io.IOException;
import java.io.Reader;

public class CompositeReader
extends Reader {
    private final Reader[] readers;
    private int index;

    public CompositeReader(Reader ... readers) {
        this.readers = readers;
    }

    @Override
    public void close() throws IOException {
        for (Reader reader : this.readers) {
            reader.close();
        }
    }

    @Override
    public int read(char[] buffer, int offset, int length) throws IOException {
        if (this.index >= this.readers.length) {
            return -1;
        }
        int readCount = this.readers[this.index].read(buffer, offset, length);
        if (readCount < 0) {
            ++this.index;
            return this.read(buffer, offset, length);
        }
        return readCount;
    }
}

