/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.test;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionNotFoundException;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.AbstractExtensionRepository;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.internal.ExtensionSerializer;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtension;
import org.xwiki.extension.repository.result.CollectionIterableResult;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.test.ResourceExtension;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.internal.DefaultVersion;

public class ResourceExtensionRepository
extends AbstractExtensionRepository
implements ExtensionRepository {
    private ExtensionSerializer extensionSerializer;
    private ClassLoader classLoader;
    private String baseResource;

    public ResourceExtensionRepository(ClassLoader classLoader, String baseResource, ComponentManager componentManager) throws ComponentLookupException {
        super((ExtensionRepositoryDescriptor)new DefaultExtensionRepositoryDescriptor("test-resources", "resources", null));
        this.extensionSerializer = (ExtensionSerializer)componentManager.getInstance(ExtensionSerializer.class);
        this.classLoader = classLoader;
        this.baseResource = baseResource;
    }

    InputStream getResourceAsStream(ExtensionId extensionId, String type) throws UnsupportedEncodingException {
        return this.classLoader.getResourceAsStream(this.getEncodedPath(extensionId, type));
    }

    URL getResource(ExtensionId extensionId, String type) throws UnsupportedEncodingException {
        return this.classLoader.getResource(this.getEncodedPath(extensionId, type));
    }

    String getEncodedPath(ExtensionId extensionId, String type) throws UnsupportedEncodingException {
        return this.baseResource + URLEncoder.encode(this.getPathSuffix(extensionId, type), "UTF-8");
    }

    String getPathSuffix(ExtensionId extensionId, String type) {
        return extensionId.getId() + '-' + extensionId.getVersion().getValue() + '.' + type;
    }

    public Extension resolve(ExtensionId extensionId) throws ResolveException {
        InputStream descriptor;
        try {
            descriptor = this.getResourceAsStream(extensionId, "xed");
        }
        catch (UnsupportedEncodingException e) {
            throw new ResolveException("Invalid extension id [" + extensionId + "]", (Throwable)e);
        }
        if (descriptor == null) {
            throw new ExtensionNotFoundException("Extension [" + extensionId + "] not found");
        }
        try {
            DefaultLocalExtension localExtension = this.extensionSerializer.loadLocalExtensionDescriptor(null, descriptor);
            return new ResourceExtension(this, (Extension)localExtension);
        }
        catch (Exception e) {
            throw new ResolveException("Failed to parse descriptor for extension [" + extensionId + "]", (Throwable)e);
        }
    }

    public Extension resolve(ExtensionDependency extensionDependency) throws ResolveException {
        return this.resolve(new ExtensionId(extensionDependency.getId(), (Version)new DefaultVersion(extensionDependency.getVersionConstraint().getValue())));
    }

    public boolean exists(ExtensionId extensionId) {
        try {
            return this.getResource(extensionId, "xed") != null;
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }

    public IterableResult<Version> resolveVersions(String id, int offset, int nb) throws ResolveException {
        return new CollectionIterableResult(0, offset, Collections.emptyList());
    }
}

