/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.handler.internal;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.ExtensionException;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.handler.ExtensionHandler;
import org.xwiki.extension.handler.ExtensionHandlerManager;
import org.xwiki.job.Request;

@Component
@Singleton
public class DefaultExtensionHandlerManager
implements ExtensionHandlerManager {
    private static final String LOOKUPERROR = "Can't find any extension handler for the extension ";
    @Inject
    private ComponentManager componentManager;

    private ExtensionHandler getExtensionHandler(LocalExtension localExtension) throws ComponentLookupException {
        return (ExtensionHandler)this.componentManager.getInstance(ExtensionHandler.class, localExtension.getType().toLowerCase());
    }

    @Override
    public void install(LocalExtension localExtension, String namespace, Request request) throws InstallException {
        ExtensionHandler extensionHandler;
        try {
            extensionHandler = this.getExtensionHandler(localExtension);
        }
        catch (ComponentLookupException e) {
            throw new InstallException("Can't find any extension handler for the extension [" + localExtension + ']', e);
        }
        try {
            extensionHandler.install(localExtension, namespace, request);
        }
        catch (Exception e) {
            throw new InstallException("Failed to install extension [" + localExtension.getId() + "]", e);
        }
    }

    @Override
    public void uninstall(LocalExtension localExtension, String namespace, Request request) throws UninstallException {
        ExtensionHandler extensionHandler;
        try {
            extensionHandler = this.getExtensionHandler(localExtension);
        }
        catch (ComponentLookupException e) {
            throw new UninstallException("Can't find any extension handler for the extension [" + localExtension + ']', e);
        }
        try {
            extensionHandler.uninstall(localExtension, namespace, request);
        }
        catch (UninstallException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UninstallException("Failed to uninstall extension [" + localExtension.getId() + "]", e);
        }
    }

    @Override
    public void upgrade(LocalExtension previousLocalExtension, LocalExtension newLocalExtension, String namespace, Request request) throws InstallException {
        ExtensionHandler extensionHandler;
        try {
            extensionHandler = this.getExtensionHandler(previousLocalExtension);
        }
        catch (ComponentLookupException e) {
            throw new InstallException("Can't find any extension handler for the extension [" + previousLocalExtension + ']', e);
        }
        try {
            extensionHandler.upgrade(previousLocalExtension, newLocalExtension, namespace, request);
        }
        catch (InstallException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InstallException("Failed to upgrade from extension [" + previousLocalExtension + "] to extension [" + newLocalExtension.getId() + "]", e);
        }
    }

    @Override
    public void initialize(LocalExtension localExtension, String namespace) throws ExtensionException {
        try {
            ExtensionHandler extensionHandler = this.getExtensionHandler(localExtension);
            extensionHandler.initialize(localExtension, namespace);
        }
        catch (Exception e) {
            throw new InstallException("Failed to initialize extension [" + localExtension.getId() + "]", e);
        }
    }
}

