/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.extension.Extension;
import org.xwiki.extension.repository.result.CollectionIterableResult;

public final class RepositoryUtils {
    public static final String SEARCH_PATTERN_SUFFIXNPREFIX = ".*";

    private RepositoryUtils() {
    }

    public static CollectionIterableResult<Extension> searchInCollection(String pattern, int offset, int nb, Collection<? extends Extension> extensions) {
        int toIndex;
        List<Object> result = StringUtils.isEmpty((CharSequence)pattern) ? (extensions instanceof List ? (List<Object>)extensions : new ArrayList<Extension>(extensions)) : RepositoryUtils.filter(pattern, extensions);
        if (nb == 0 || offset >= result.size()) {
            return new CollectionIterableResult<Extension>(result.size(), offset, Collections.emptyList());
        }
        int fromIndex = offset;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (nb > 0) {
            toIndex = nb + fromIndex;
            if (toIndex > result.size()) {
                toIndex = result.size();
            }
        } else {
            toIndex = result.size();
        }
        return new CollectionIterableResult<Extension>(result.size(), offset, result.subList(fromIndex, toIndex));
    }

    public static <T> CollectionIterableResult<T> getIterableResult(int offset, int nb, Collection<T> elements) {
        if (nb == 0 || offset >= elements.size()) {
            return new CollectionIterableResult(elements.size(), offset, Collections.emptyList());
        }
        ArrayList<T> list = elements instanceof List ? (ArrayList<T>)elements : new ArrayList<T>(elements);
        return RepositoryUtils.getIterableResultFromList(offset, nb, list);
    }

    private static <T> CollectionIterableResult<T> getIterableResultFromList(int offset, int nb, List<T> elements) {
        int toIndex;
        int fromIndex = offset;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (nb > 0) {
            toIndex = nb + fromIndex;
            if (toIndex > elements.size()) {
                toIndex = elements.size();
            }
        } else {
            toIndex = elements.size();
        }
        return new CollectionIterableResult<T>(elements.size(), offset, elements.subList(fromIndex, toIndex));
    }

    private static List<Extension> filter(String pattern, Collection<? extends Extension> extensions) {
        ArrayList<Extension> result = new ArrayList<Extension>();
        Pattern patternMatcher = Pattern.compile(SEARCH_PATTERN_SUFFIXNPREFIX + pattern.toLowerCase() + SEARCH_PATTERN_SUFFIXNPREFIX);
        for (Extension extension : extensions) {
            if (!RepositoryUtils.matches(patternMatcher, extension)) continue;
            result.add(extension);
        }
        return result;
    }

    public static boolean matches(Pattern patternMatcher, Extension extension) {
        return RepositoryUtils.matches(patternMatcher, extension.getId().getId(), extension.getDescription(), extension.getSummary(), extension.getName(), extension.getFeatures());
    }

    public static boolean matches(Pattern patternMatcher, Object ... elements) {
        for (Object element : elements) {
            if (element == null || !patternMatcher.matcher(element.toString().toLowerCase()).matches()) continue;
            return true;
        }
        return false;
    }
}

