/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.test;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.reflections.vfs.Vfs;
import org.xwiki.extension.ExtensionId;

public class ExtensionPackager {
    public static final String PACKAGEFILE_PACKAGE = "packagefile";
    public static final String PACKAGEFILE_DESCRIPTOR = "packagefile.properties";
    private File workingDirectory;
    private Map<String, File> repositories;
    private Map<ExtensionId, File> extensionsFiles = new HashMap<ExtensionId, File>();

    public ExtensionPackager(File workingDirectory, File repository) {
        this(workingDirectory, Collections.singletonMap(null, repository));
    }

    public ExtensionPackager(File workingDirectory, Map<String, File> repositories) {
        this.workingDirectory = workingDirectory;
        this.repositories = repositories;
    }

    public File getExtensionFile(ExtensionId extensionId) {
        return this.extensionsFiles.get(extensionId);
    }

    public void generateExtensions() throws IOException {
        Set urls = ClasspathHelper.forPackage((String)PACKAGEFILE_PACKAGE, (ClassLoader[])new ClassLoader[0]);
        if (!urls.isEmpty()) {
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new ResourcesScanner()}).setUrls((Collection)urls).filterInputsBy((Predicate)new FilterBuilder.Include(FilterBuilder.prefix((String)PACKAGEFILE_PACKAGE))));
            Set descriptors = reflections.getResources(Predicates.equalTo((Object)PACKAGEFILE_DESCRIPTOR));
            for (String descriptor : descriptors) {
                String classPackageFolder = descriptor.substring(0, descriptor.length() - PACKAGEFILE_DESCRIPTOR.length());
                this.generateExtension(classPackageFolder, this.getClass().getClassLoader().getResource(descriptor));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateExtension(String classPackageFolder, URL descriptorUrl) throws IOException {
        File packageFile;
        String version;
        String id;
        String descriptorUrlStr = descriptorUrl.toString();
        String descriptorFolderURL = descriptorUrlStr.substring(0, descriptorUrlStr.length() - PACKAGEFILE_DESCRIPTOR.length());
        Properties descriptorProperties = new Properties();
        InputStream descriptorStream = descriptorUrl.openStream();
        try {
            descriptorProperties.load(descriptorStream);
        }
        finally {
            descriptorStream.close();
        }
        String type = descriptorProperties.getProperty("type");
        if (type == null) {
            type = "zip";
        }
        if ((id = descriptorProperties.getProperty("id")) == null) {
            id = descriptorFolderURL.substring(0, descriptorFolderURL.length() - 1);
            id = id.substring(id.lastIndexOf(47) + 1);
        }
        if ((version = descriptorProperties.getProperty("version")) == null) {
            version = "1.0";
        }
        String directory = descriptorProperties.getProperty("directory");
        String fileName = descriptorProperties.getProperty("fileName");
        String repositoryName = descriptorProperties.getProperty("repository");
        if (directory == null) {
            packageFile = fileName == null ? new File(this.repositories.get(repositoryName), URLEncoder.encode(id + '-' + version + '.' + type, "UTF-8")) : new File(this.repositories.get(repositoryName), fileName);
        } else {
            if (fileName == null) {
                fileName = URLEncoder.encode(id + '-' + version + '.' + type, "UTF-8");
            }
            packageFile = new File(this.workingDirectory, directory);
            packageFile = new File(packageFile, fileName);
        }
        packageFile.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(packageFile);
        try {
            ZipOutputStream zos;
            if (type.equals("jar")) {
                Manifest manifest = new Manifest();
                manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
                zos = new JarOutputStream((OutputStream)fos, manifest);
            } else {
                zos = new ZipOutputStream(fos);
            }
            try {
                for (Vfs.File resourceFile : Vfs.fromURL((URL)new URL(descriptorFolderURL)).getFiles()) {
                    if (resourceFile.getRelativePath().equals(PACKAGEFILE_DESCRIPTOR)) continue;
                    this.addZipEntry(classPackageFolder, resourceFile, zos, type);
                }
            }
            finally {
                zos.close();
            }
            this.extensionsFiles.put(new ExtensionId(id, version), packageFile);
        }
        finally {
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addZipEntry(String classPackageFolder, Vfs.File resourceFile, ZipOutputStream zos, String type) throws IOException {
        String zipPath = type.equals("jar") && resourceFile.getName().endsWith(".class") ? classPackageFolder + resourceFile.getRelativePath() : resourceFile.getRelativePath();
        ZipEntry entry = new ZipEntry(zipPath);
        zos.putNextEntry(entry);
        InputStream resourceStream = resourceFile.openInputStream();
        try {
            IOUtils.copy((InputStream)resourceStream, (OutputStream)zos);
        }
        finally {
            resourceStream.close();
        }
        zos.closeEntry();
    }
}

