/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.version.VersionConstraint;

public abstract class AbstractExtensionDependency
implements ExtensionDependency {
    protected String id;
    protected VersionConstraint versionConstraint;
    protected Map<String, Object> properties = new HashMap<String, Object>();

    public AbstractExtensionDependency(ExtensionDependency dependency, VersionConstraint versionConstraint) {
        this(dependency.getId(), versionConstraint, dependency.getProperties());
    }

    public AbstractExtensionDependency(String id, VersionConstraint versionConstraint) {
        this(id, versionConstraint, null);
    }

    public AbstractExtensionDependency(String id, VersionConstraint versionConstraint, Map<String, Object> properties) {
        this.id = id;
        this.versionConstraint = versionConstraint;
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    public void setVersionConstraint(VersionConstraint versionConstraint) {
        this.versionConstraint = versionConstraint;
    }

    @Override
    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    protected void putProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    @Override
    public <T> T getProperty(String key, T def) {
        return (T)(this.properties.containsKey(key) ? this.properties.get(key) : def);
    }

    public String toString() {
        return this.getId() + '-' + this.getVersionConstraint();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getId());
        builder.append((Object)this.getVersionConstraint());
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        boolean equals;
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExtensionDependency) {
            ExtensionDependency otherDependency = (ExtensionDependency)obj;
            equals = StringUtils.equals((CharSequence)this.getId(), (CharSequence)otherDependency.getId()) && ObjectUtils.equals((Object)this.getVersionConstraint(), (Object)otherDependency.getVersionConstraint());
        } else {
            equals = false;
        }
        return equals;
    }
}

