/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Marker;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.DefaultExtensionDependency;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.handler.ExtensionHandler;
import org.xwiki.extension.job.ExtensionRequest;
import org.xwiki.extension.job.internal.AbstractExtensionPlanJob;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.extension.job.plan.ExtensionPlanNode;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlan;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlanAction;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlanNode;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlanTree;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.version.IncompatibleVersionConstraintException;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionConstraint;

public abstract class AbstractInstallPlanJob<R extends ExtensionRequest>
extends AbstractExtensionPlanJob<R> {
    @Inject
    protected ExtensionRepositoryManager repositoryManager;
    @Inject
    protected CoreExtensionRepository coreExtensionRepository;
    private Map<String, Map<String, ModifableExtensionPlanNode>> extensionsNodeCache = new HashMap<String, Map<String, ModifableExtensionPlanNode>>();

    protected void setExtensionTree(ModifableExtensionPlanTree extensionTree) {
        this.extensionTree = extensionTree;
        ((DefaultExtensionPlan)this.status).setTree(this.extensionTree);
    }

    protected void addExtensionToProcess(Map<ExtensionId, Collection<String>> extensionsByNamespace, ExtensionId extensionId, String namespace) {
        Collection<Object> namespaces;
        if (extensionsByNamespace.containsKey(extensionId) && namespace != null) {
            namespaces = extensionsByNamespace.get(extensionId);
        } else {
            namespaces = namespace == null ? null : new HashSet();
            extensionsByNamespace.put(extensionId, namespaces);
        }
        if (namespaces != null) {
            namespaces.add(namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(Map<ExtensionId, Collection<String>> extensionsByNamespace) throws Exception {
        this.progressManager.pushLevelProgress(extensionsByNamespace.size(), (Object)this);
        try {
            for (Map.Entry<ExtensionId, Collection<String>> entry : extensionsByNamespace.entrySet()) {
                ExtensionId extensionId = entry.getKey();
                Collection<String> namespaces = entry.getValue();
                if (namespaces != null) {
                    this.progressManager.pushLevelProgress(namespaces.size(), (Object)this);
                    try {
                        for (String namespace : namespaces) {
                            this.installExtension(extensionId, namespace, this.extensionTree);
                            this.progressManager.stepPropress((Object)this);
                        }
                    }
                    finally {
                        this.progressManager.popLevelProgress((Object)this);
                    }
                } else {
                    this.installExtension(extensionId, null, this.extensionTree);
                }
                this.progressManager.stepPropress((Object)this);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private ModifableExtensionPlanNode getExtensionNode(String id, String namespace) {
        Map<String, ModifableExtensionPlanNode> extensionsById = this.extensionsNodeCache.get(id);
        ModifableExtensionPlanNode node = null;
        if (extensionsById != null && (node = extensionsById.get(namespace)) == null && namespace != null) {
            node = extensionsById.get(null);
        }
        return node;
    }

    private void addExtensionNode(ModifableExtensionPlanNode node) {
        ModifableExtensionPlanNode existingNode;
        String id = node.getAction().getExtension().getId().getId();
        Map<String, ModifableExtensionPlanNode> extensionsById = this.extensionsNodeCache.get(id);
        if (extensionsById == null) {
            extensionsById = new HashMap<String, ModifableExtensionPlanNode>();
            this.extensionsNodeCache.put(id, extensionsById);
        }
        if ((existingNode = extensionsById.get(node.getAction().getNamespace())) != null) {
            existingNode.set(node);
            for (ModifableExtensionPlanNode duplicate : existingNode.duplicates) {
                duplicate.set(node);
            }
            existingNode.duplicates.add(node);
        } else {
            extensionsById.put(node.getAction().getNamespace(), node);
        }
    }

    protected void installExtension(ExtensionId extensionId, String namespace, ModifableExtensionPlanTree parentBranch) throws InstallException {
        try {
            this.installExtension(extensionId, false, namespace, parentBranch);
        }
        catch (ResolveException e) {
            throw new InstallException("An unexpected exception has been raised", e);
        }
    }

    protected Collection<InstalledExtension> checkAlreadyInstalledExtensions(String id, Version version, String namespace) throws ResolveException, InstallException {
        InstalledExtension previousExtension = this.installedExtensionRepository.getInstalledExtension(id, namespace);
        if (previousExtension != null) {
            if (((ExtensionRequest)this.getRequest()).isVerbose()) {
                this.logger.debug("Found already installed extension with id [{}]. Checking compatibility...", (Object)id);
            }
            if (version == null) {
                throw new InstallException(String.format("The extension with id [%s] is already installed", id));
            }
            int versionDiff = version.compareTo(previousExtension.getId().getVersion());
            if (versionDiff == 0) {
                throw new InstallException(String.format("The extension [%s-%s] is already installed", id, version));
            }
            if (previousExtension.isInstalled(null)) {
                Map<String, Collection<InstalledExtension>> backwardDependencies = this.installedExtensionRepository.getBackwardDependencies(previousExtension.getId());
                if (!this.isCompatible(backwardDependencies.get(null), id, version)) {
                    throw new InstallException(String.format("The extension [%s-%s] is not compatible with previous version ([%s]) backward dependencies", id, version, previousExtension.getId()));
                }
                if (namespace != null && !this.isCompatible(backwardDependencies.get(namespace), id, version)) {
                    throw new InstallException(String.format("The extension [%s-%s] is not compatible with previous version ([%s]) backward dependencies on namespace [%s]", id, version, previousExtension.getId(), namespace));
                }
            } else {
                Collection<InstalledExtension> backwardDependencies = this.installedExtensionRepository.getBackwardDependencies(previousExtension.getId().getId(), namespace);
                if (!this.isCompatible(backwardDependencies, id, version)) {
                    throw new InstallException(String.format("The extension [%s-%s] is not compatible with previous version ([%s]) backward dependencies on namespace [%s]", id, version, previousExtension.getId(), namespace));
                }
            }
            return Arrays.asList(previousExtension);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installExtension(ExtensionId extensionId, boolean dependency, String namespace, ModifableExtensionPlanTree parentBranch) throws InstallException, ResolveException {
        if (((ExtensionRequest)this.getRequest()).isVerbose()) {
            if (namespace != null) {
                this.logger.info((Marker)LOG_RESOLVE_NAMESPACE, "Resolving extension [{}] on namespace [{}]", (Object)extensionId, (Object)namespace);
            } else {
                this.logger.info((Marker)LOG_RESOLVE, "Resolving extension [{}] on all namespaces", (Object)extensionId);
            }
        }
        if (this.coreExtensionRepository.exists(extensionId.getId())) {
            throw new InstallException(String.format("There is already a core extension with the id [%s]", extensionId.getId()));
        }
        this.progressManager.pushLevelProgress(3, (Object)this);
        try {
            Collection<InstalledExtension> previousExtensions = this.checkAlreadyInstalledExtensions(extensionId.getId(), extensionId.getVersion(), namespace);
            this.progressManager.stepPropress((Object)this);
            if (previousExtensions.isEmpty() && namespace == null) {
                try {
                    this.uninstallFromNamespaces(extensionId.getId());
                }
                catch (UninstallException e) {
                    throw new InstallException("Failed to uninstall feature [" + extensionId.getId() + "] from namespaces", e);
                }
            }
            this.progressManager.stepPropress((Object)this);
            ModifableExtensionPlanNode node = this.installExtension(previousExtensions, extensionId, dependency, namespace);
            this.addExtensionNode(node);
            parentBranch.add(node);
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private boolean isCompatible(Collection<? extends Extension> extensions, String id, Version version) {
        if (extensions != null) {
            for (Extension extension : extensions) {
                for (ExtensionDependency extensionDependency : extension.getDependencies()) {
                    if (!extensionDependency.getId().equals(id) || extensionDependency.getVersionConstraint().isCompatible(version)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkCoreExtension(ExtensionDependency extensionDependency, List<ModifableExtensionPlanNode> parentBranch) throws InstallException {
        CoreExtension coreExtension = this.coreExtensionRepository.getCoreExtension(extensionDependency.getId());
        if (coreExtension != null) {
            if (!extensionDependency.getVersionConstraint().isCompatible(coreExtension.getId().getVersion())) {
                throw new InstallException("Dependency [" + extensionDependency + "] is not compatible with core extension [" + coreExtension + "]");
            }
            if (((ExtensionRequest)this.getRequest()).isVerbose()) {
                this.logger.debug("There is already a core extension [{}] covering extension dependency [{}]", (Object)coreExtension.getId(), (Object)extensionDependency);
            }
            ModifableExtensionPlanNode node = new ModifableExtensionPlanNode(extensionDependency, extensionDependency.getVersionConstraint());
            node.setAction(new DefaultExtensionPlanAction(coreExtension, null, ExtensionPlanAction.Action.NONE, null, true));
            parentBranch.add(node);
            return true;
        }
        return false;
    }

    private VersionConstraint checkExistingPlanNode(ExtensionDependency extensionDependency, String namespace, List<ModifableExtensionPlanNode> parentBranch, VersionConstraint previousVersionConstraint) throws InstallException {
        VersionConstraint versionConstraint = previousVersionConstraint;
        ModifableExtensionPlanNode existingNode = this.getExtensionNode(extensionDependency.getId(), namespace);
        if (existingNode != null) {
            if (versionConstraint.isCompatible(existingNode.getAction().getExtension().getId().getVersion())) {
                ModifableExtensionPlanNode node = new ModifableExtensionPlanNode(extensionDependency, existingNode);
                this.addExtensionNode(node);
                parentBranch.add(node);
                return null;
            }
            if (existingNode.versionConstraint != null) {
                try {
                    versionConstraint = versionConstraint.merge(existingNode.versionConstraint);
                }
                catch (IncompatibleVersionConstraintException e) {
                    throw new InstallException("Dependency [" + extensionDependency + "] is incompatible with current containt [" + existingNode.versionConstraint + "]", e);
                }
            } else {
                throw new InstallException("Dependency [" + extensionDependency + "] incompatible with extension [" + existingNode.getAction().getExtension() + "]");
            }
        }
        return versionConstraint;
    }

    private ExtensionDependency checkInstalledExtension(InstalledExtension installedExtension, ExtensionDependency extensionDependency, VersionConstraint versionConstraint, String namespace, List<ModifableExtensionPlanNode> parentBranch) throws InstallException {
        ExtensionDependency targetDependency = extensionDependency;
        if (installedExtension != null) {
            VersionConstraint mergedVersionContraint;
            if (installedExtension.isValid(namespace) && versionConstraint.isCompatible(installedExtension.getId().getVersion())) {
                if (((ExtensionRequest)this.getRequest()).isVerbose()) {
                    this.logger.debug("There is already an installed extension [{}] covering extension dependency [{}]", (Object)installedExtension.getId(), (Object)extensionDependency);
                }
                ModifableExtensionPlanNode node = new ModifableExtensionPlanNode(extensionDependency, versionConstraint);
                node.setAction(new DefaultExtensionPlanAction(installedExtension, null, ExtensionPlanAction.Action.NONE, namespace, installedExtension.isDependency(namespace)));
                this.addExtensionNode(node);
                parentBranch.add(node);
                return null;
            }
            try {
                if (installedExtension.isInstalled(null)) {
                    Map<String, Collection<InstalledExtension>> backwardDependencies = this.installedExtensionRepository.getBackwardDependencies(installedExtension.getId());
                    mergedVersionContraint = this.mergeVersionConstraints(backwardDependencies.get(null), extensionDependency.getId(), versionConstraint);
                    if (namespace != null) {
                        mergedVersionContraint = this.mergeVersionConstraints(backwardDependencies.get(namespace), extensionDependency.getId(), mergedVersionContraint);
                    }
                } else {
                    Collection<InstalledExtension> backwardDependencies = this.installedExtensionRepository.getBackwardDependencies(installedExtension.getId().getId(), namespace);
                    mergedVersionContraint = this.mergeVersionConstraints(backwardDependencies, extensionDependency.getId(), versionConstraint);
                }
            }
            catch (IncompatibleVersionConstraintException e) {
                throw new InstallException("Provided depency is incompatible with already installed extensions", e);
            }
            catch (ResolveException e) {
                throw new InstallException("Failed to resolve backward dependencies", e);
            }
            if (mergedVersionContraint != versionConstraint) {
                targetDependency = new DefaultExtensionDependency(extensionDependency, mergedVersionContraint);
            }
        }
        return targetDependency;
    }

    private void installExtensionDependency(ExtensionDependency extensionDependency, String namespace, List<ModifableExtensionPlanNode> parentBranch) throws InstallException {
        if (((ExtensionRequest)this.getRequest()).isVerbose()) {
            if (namespace != null) {
                this.logger.info((Marker)LOG_RESOLVEDEPENDENCY_NAMESPACE, "Resolving extension dependency [{}] on namespace [{}]", (Object)extensionDependency, (Object)namespace);
            } else {
                this.logger.info((Marker)LOG_RESOLVEDEPENDENCY, "Resolving extension dependency [{}] on all namespaces", (Object)extensionDependency);
            }
        }
        VersionConstraint versionConstraint = extensionDependency.getVersionConstraint();
        if (this.checkCoreExtension(extensionDependency, parentBranch)) {
            return;
        }
        if ((versionConstraint = this.checkExistingPlanNode(extensionDependency, namespace, parentBranch, versionConstraint)) == null) {
            return;
        }
        InstalledExtension previousExtension = this.installedExtensionRepository.getInstalledExtension(extensionDependency.getId(), namespace);
        ExtensionDependency targetDependency = this.checkInstalledExtension(previousExtension, extensionDependency, versionConstraint, namespace, parentBranch);
        if (targetDependency == null) {
            return;
        }
        ModifableExtensionPlanNode node = this.installExtension(previousExtension != null ? Arrays.asList(previousExtension) : Collections.emptyList(), targetDependency, true, namespace);
        node.versionConstraint = versionConstraint;
        this.addExtensionNode(node);
        parentBranch.add(node);
    }

    private ModifableExtensionPlanNode installExtension(Collection<InstalledExtension> previousExtensions, ExtensionDependency targetDependency, boolean dependency, String namespace) throws InstallException {
        this.progressManager.pushLevelProgress(2, (Object)this);
        try {
            Extension extension = this.resolveExtension(targetDependency);
            this.progressManager.stepPropress((Object)this);
            try {
                ModifableExtensionPlanNode modifableExtensionPlanNode = this.installExtension(previousExtensions, extension, dependency, namespace, targetDependency);
                return modifableExtensionPlanNode;
            }
            catch (Exception e) {
                throw new InstallException("Failed to resolve extension dependency", e);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private VersionConstraint mergeVersionConstraints(Collection<? extends Extension> extensions, String dependencyId, VersionConstraint previousMergedVersionContraint) throws IncompatibleVersionConstraintException {
        VersionConstraint mergedVersionContraint = previousMergedVersionContraint;
        if (extensions != null) {
            for (Extension extension : extensions) {
                ExtensionDependency dependency = this.getDependency(extension, dependencyId);
                if (dependency == null) continue;
                if (mergedVersionContraint == null) {
                    mergedVersionContraint = dependency.getVersionConstraint();
                    continue;
                }
                mergedVersionContraint = mergedVersionContraint.merge(dependency.getVersionConstraint());
            }
        }
        return mergedVersionContraint;
    }

    private ExtensionDependency getDependency(Extension extension, String dependencyId) {
        for (ExtensionDependency extensionDependency : extension.getDependencies()) {
            if (!extensionDependency.getId().equals(dependencyId)) continue;
            return extensionDependency;
        }
        return null;
    }

    private ModifableExtensionPlanNode installExtension(Collection<InstalledExtension> previousExtensions, ExtensionId extensionId, boolean dependency, String namespace) throws InstallException {
        this.progressManager.pushLevelProgress(2, (Object)this);
        try {
            Extension extension = this.resolveExtension(extensionId);
            this.progressManager.stepPropress((Object)this);
            try {
                ModifableExtensionPlanNode modifableExtensionPlanNode = this.installExtension(previousExtensions, extension, dependency, namespace, null);
                return modifableExtensionPlanNode;
            }
            catch (Exception e) {
                throw new InstallException("Failed to resolve extension", e);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private Extension resolveExtension(ExtensionId extensionId) throws InstallException {
        Extension extension = this.localExtensionRepository.getLocalExtension(extensionId);
        if (extension == null) {
            this.logger.debug("Can't find extension in local repository, trying to download it.");
            try {
                extension = this.repositoryManager.resolve(extensionId);
            }
            catch (ResolveException e1) {
                throw new InstallException(String.format("Failed to resolve extension [%s]", extensionId), e1);
            }
        }
        return extension;
    }

    private Extension resolveExtension(ExtensionDependency extensionDependency) throws InstallException {
        Extension extension;
        try {
            extension = this.localExtensionRepository.resolve(extensionDependency);
        }
        catch (ResolveException e) {
            this.logger.debug("Can't find extension dependency in local repository, trying to download it.", (Throwable)e);
            try {
                extension = this.repositoryManager.resolve(extensionDependency);
            }
            catch (ResolveException e1) {
                throw new InstallException(String.format("Failed to resolve extension dependency [%s]", extensionDependency), e1);
            }
        }
        return extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallFromNamespaces(String feature) throws UninstallException {
        Collection<InstalledExtension> installedExtensions = this.installedExtensionRepository.getInstalledExtensions();
        this.progressManager.pushLevelProgress(installedExtensions.size(), (Object)this);
        try {
            for (InstalledExtension installedExtension : installedExtensions) {
                if (installedExtension.getId().getId().equals(feature) || installedExtension.getFeatures().contains(feature)) {
                    this.uninstallExtension(installedExtension, installedExtension.getNamespaces(), (Collection<ExtensionPlanNode>)this.extensionTree);
                }
                this.progressManager.stepPropress((Object)this);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private ModifableExtensionPlanNode installExtension(Collection<InstalledExtension> previousExtensions, Extension extension, boolean dependency, String namespace, ExtensionDependency initialDependency) throws InstallException, ResolveException {
        for (String feature : extension.getFeatures()) {
            if (!this.coreExtensionRepository.exists(feature)) continue;
            throw new InstallException(String.format("There is already a core extension with the id [%s]", feature));
        }
        this.progressManager.pushLevelProgress(3, (Object)this);
        try {
            void var11_18;
            ExtensionHandler extensionHandler;
            LinkedHashSet<InstalledExtension> finalPreviousExtensions = new LinkedHashSet<InstalledExtension>();
            if (previousExtensions != null) {
                finalPreviousExtensions.addAll(previousExtensions);
            }
            if (!extension.getFeatures().isEmpty()) {
                this.progressManager.pushLevelProgress(extension.getFeatures().size(), (Object)this);
                try {
                    for (String feature : extension.getFeatures()) {
                        Collection<InstalledExtension> installedExtensions = this.checkAlreadyInstalledExtensions(feature, extension.getId().getVersion(), namespace);
                        if (installedExtensions.isEmpty()) {
                            if (namespace == null) {
                                try {
                                    this.uninstallFromNamespaces(feature);
                                }
                                catch (UninstallException e) {
                                    throw new InstallException("Failed to uninstall feature [" + feature + "] from namespaces", e);
                                }
                            }
                        } else {
                            finalPreviousExtensions.addAll(installedExtensions);
                        }
                        this.progressManager.stepPropress((Object)this);
                    }
                }
                finally {
                    this.progressManager.popLevelProgress((Object)this);
                }
            }
            this.progressManager.stepPropress((Object)this);
            try {
                extensionHandler = (ExtensionHandler)this.componentManager.getInstance(ExtensionHandler.class, extension.getType());
            }
            catch (ComponentLookupException e) {
                throw new InstallException(String.format("Unsupported type [%s]", extension.getType()), e);
            }
            extensionHandler.checkInstall(extension, namespace, this.getRequest());
            Collection<? extends ExtensionDependency> dependencies = extension.getDependencies();
            ArrayList<ModifableExtensionPlanNode> children = null;
            if (!dependencies.isEmpty()) {
                this.progressManager.pushLevelProgress(dependencies.size() + 1, (Object)this);
                try {
                    children = new ArrayList<ModifableExtensionPlanNode>();
                    for (ExtensionDependency extensionDependency : extension.getDependencies()) {
                        this.installExtensionDependency(extensionDependency, namespace, children);
                        this.progressManager.stepPropress((Object)this);
                    }
                }
                finally {
                    this.progressManager.popLevelProgress((Object)this);
                }
            }
            this.progressManager.stepPropress((Object)this);
            ModifableExtensionPlanNode node = initialDependency != null ? new ModifableExtensionPlanNode(initialDependency, initialDependency.getVersionConstraint()) : new ModifableExtensionPlanNode();
            node.setChildren(children);
            if (!finalPreviousExtensions.isEmpty()) {
                if (((InstalledExtension)finalPreviousExtensions.iterator().next()).getId().getVersion().compareTo(extension.getId().getVersion()) > 0) {
                    ExtensionPlanAction.Action action = ExtensionPlanAction.Action.DOWNGRADE;
                } else {
                    ExtensionPlanAction.Action action = ExtensionPlanAction.Action.UPGRADE;
                }
            } else {
                ExtensionPlanAction.Action action = ExtensionPlanAction.Action.INSTALL;
            }
            node.setAction(new DefaultExtensionPlanAction(extension, finalPreviousExtensions, (ExtensionPlanAction.Action)var11_18, namespace, dependency));
            ModifableExtensionPlanNode modifableExtensionPlanNode = node;
            return modifableExtensionPlanNode;
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    protected static class ModifableExtensionPlanNode
    extends DefaultExtensionPlanNode
    implements Cloneable {
        private final ExtensionDependency initialDependency;
        public VersionConstraint versionConstraint;
        public final List<ModifableExtensionPlanNode> duplicates = new ArrayList<ModifableExtensionPlanNode>();

        public ModifableExtensionPlanNode() {
            this.initialDependency = null;
        }

        public ModifableExtensionPlanNode(ExtensionDependency initialDependency, VersionConstraint versionConstraint) {
            this.initialDependency = initialDependency;
            this.versionConstraint = versionConstraint;
        }

        public ModifableExtensionPlanNode(ExtensionDependency initialDependency, ModifableExtensionPlanNode node) {
            this.initialDependency = initialDependency;
            this.set(node);
        }

        protected ModifableExtensionPlanNode clone() {
            try {
                return (ModifableExtensionPlanNode)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        public void set(ModifableExtensionPlanNode node) {
            this.action = node.action;
            this.children = node.children;
        }

        @Override
        public VersionConstraint getInitialVersionConstraint() {
            return this.initialDependency != null ? this.initialDependency.getVersionConstraint() : null;
        }

        public void setAction(ExtensionPlanAction action) {
            this.action = action;
        }

        public void setChildren(Collection<? extends ExtensionPlanNode> children) {
            this.children = children;
        }
    }

    protected static class ModifableExtensionPlanTree
    extends DefaultExtensionPlanTree
    implements Cloneable {
        private static final long serialVersionUID = 1L;

        protected ModifableExtensionPlanTree() {
        }

        @Override
        public ModifableExtensionPlanTree clone() {
            ModifableExtensionPlanTree tree = new ModifableExtensionPlanTree();
            for (ExtensionPlanNode node : this) {
                tree.add(((ModifableExtensionPlanNode)node).clone());
            }
            return tree;
        }
    }
}

