/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.AbstractExtensionRepository;
import org.xwiki.extension.repository.internal.RepositoryUtils;
import org.xwiki.extension.repository.result.CollectionIterableResult;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.repository.search.SearchException;
import org.xwiki.extension.repository.search.Searchable;
import org.xwiki.extension.version.Version;

public abstract class AbstractCachedExtensionRepository<E extends Extension>
extends AbstractExtensionRepository
implements Searchable {
    protected transient Map<ExtensionId, E> extensions = new ConcurrentHashMap<ExtensionId, E>();
    protected Map<String, List<E>> extensionsVersions = new ConcurrentHashMap<String, List<E>>();

    protected void addCachedExtension(E extension) {
        if (!this.extensions.containsKey(extension.getId())) {
            this.extensions.put(extension.getId(), extension);
            this.addCachedExtensionVersion(extension.getId().getId(), extension);
            for (String feature : extension.getFeatures()) {
                this.addCachedExtensionVersion(feature, extension);
            }
        }
    }

    protected void addCachedExtensionVersion(String feature, E extension) {
        List<E> versions = this.extensionsVersions.get(feature);
        if (versions == null) {
            versions = new ArrayList();
            this.extensionsVersions.put(feature, versions);
            versions.add(extension);
        } else {
            int index;
            for (index = 0; index < versions.size() && extension.getId().getVersion().compareTo(((Extension)versions.get(index)).getId().getVersion()) < 0; ++index) {
            }
            versions.add(index, extension);
        }
    }

    protected void removeCachedExtension(E extension) {
        this.extensions.remove(extension.getId());
        this.removeCachedExtensionVersion(extension.getId().getId(), extension);
        for (String feature : extension.getFeatures()) {
            this.removeCachedExtensionVersion(feature, extension);
        }
    }

    protected void removeCachedExtensionVersion(String feature, E extension) {
        List<E> extensionVersions = this.extensionsVersions.get(feature);
        extensionVersions.remove(extension);
        if (extensionVersions.isEmpty()) {
            this.extensionsVersions.remove(feature);
        }
    }

    public E resolve(ExtensionId extensionId) throws ResolveException {
        Extension extension = (Extension)this.extensions.get(extensionId);
        if (extension == null) {
            throw new ResolveException("Can't find extension [" + extensionId + "]");
        }
        return (E)extension;
    }

    public E resolve(ExtensionDependency extensionDependency) throws ResolveException {
        List<E> versions = this.extensionsVersions.get(extensionDependency.getId());
        if (versions != null) {
            for (Extension extension : versions) {
                if (!extensionDependency.getVersionConstraint().containsVersion(extension.getId().getVersion())) continue;
                return (E)extension;
            }
        }
        throw new ResolveException("Can't find extension dependency [" + extensionDependency + "]");
    }

    @Override
    public boolean exists(ExtensionId extensionId) {
        return this.extensions.containsKey(extensionId);
    }

    @Override
    public IterableResult<Version> resolveVersions(String id, int offset, int nb) throws ResolveException {
        List<E> versions = this.extensionsVersions.get(id);
        if (versions == null) {
            throw new ResolveException("Can't find extension with id [" + id + "]");
        }
        if (nb == 0 || offset >= versions.size()) {
            return new CollectionIterableResult<Version>(versions.size(), offset, Collections.emptyList());
        }
        int fromId = offset < 0 ? 0 : offset;
        int toId = offset + nb > versions.size() || nb < 0 ? versions.size() - 1 : offset + nb;
        ArrayList<Version> result = new ArrayList<Version>(toId - fromId);
        for (int i = toId - 1; i >= fromId; --i) {
            result.add(((Extension)versions.get(i)).getId().getVersion());
        }
        return new CollectionIterableResult<Version>(versions.size(), offset, result);
    }

    protected Pattern createPatternMatcher(String pattern) {
        return StringUtils.isEmpty((CharSequence)pattern) ? null : Pattern.compile(".*" + Pattern.quote(pattern.toLowerCase()) + ".*");
    }

    @Override
    public IterableResult<Extension> search(String pattern, int offset, int nb) throws SearchException {
        Pattern patternMatcher = this.createPatternMatcher(pattern);
        HashSet<Extension> set = new HashSet<Extension>();
        ArrayList<Extension> result = new ArrayList<Extension>(this.extensionsVersions.size());
        for (List<E> versions : this.extensionsVersions.values()) {
            Extension extension = (Extension)versions.get(0);
            if (patternMatcher != null && !RepositoryUtils.matches(patternMatcher, extension) || set.contains(extension)) continue;
            result.add(extension);
            set.add(extension);
        }
        return RepositoryUtils.getIterableResult(offset, nb, result);
    }
}

