/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.test;

import com.google.common.base.Predicate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.xwiki.extension.test.ExtensionPackager;

public class RepositoryUtils {
    protected static final String MAVENREPOSITORY_ID = "test-maven";
    protected static final String MAVEN2REPOSITORY_ID = "test-maven2";
    protected final File permanentDirectory;
    protected final File temporaryDirectory;
    protected final File extensionDirectory;
    protected final File localRepositoryRoot;
    protected final File mavenRepositoryRoot;
    protected final File maven2RepositoryRoot;
    protected final File remoteRepositoryRoot;
    protected final ExtensionPackager extensionPackager;

    public RepositoryUtils() {
        File testDirectory = new File("target/test-" + new Date().getTime());
        this.temporaryDirectory = new File(testDirectory, "temporary-dir");
        this.permanentDirectory = new File(testDirectory, "permanent-dir");
        this.extensionDirectory = new File(this.permanentDirectory, "extension/");
        this.localRepositoryRoot = new File(this.extensionDirectory, "repository/");
        this.mavenRepositoryRoot = new File(testDirectory, "maven/");
        this.maven2RepositoryRoot = new File(testDirectory, "maven2/");
        this.remoteRepositoryRoot = new File(testDirectory, "remote/");
        HashMap<String, File> repositories = new HashMap<String, File>();
        repositories.put(null, this.getRemoteRepository());
        repositories.put("remote", this.getRemoteRepository());
        repositories.put("local", this.getLocalRepository());
        this.extensionPackager = new ExtensionPackager(this.permanentDirectory, repositories);
        System.setProperty("extension.repository.local", this.localRepositoryRoot.getAbsolutePath());
        System.setProperty("extension.repository.maven", this.mavenRepositoryRoot.getAbsolutePath());
        System.setProperty("extension.repository.maven2", this.maven2RepositoryRoot.getAbsolutePath());
        System.setProperty("extension.repository.remote", this.remoteRepositoryRoot.getAbsolutePath());
    }

    public File getPermanentDirectory() {
        return this.permanentDirectory;
    }

    public File getTemporaryDirectory() {
        return this.temporaryDirectory;
    }

    public File getExtensionDirectory() {
        return this.extensionDirectory;
    }

    public File getLocalRepository() {
        return this.localRepositoryRoot;
    }

    public File getRemoteRepository() {
        return this.remoteRepositoryRoot;
    }

    public File getMavenRepository() {
        return this.mavenRepositoryRoot;
    }

    public File getMaven2Repository() {
        return this.maven2RepositoryRoot;
    }

    public String getMavenRepositoryId() {
        return MAVENREPOSITORY_ID;
    }

    public String getMaven2RepositoryId() {
        return MAVEN2REPOSITORY_ID;
    }

    public ExtensionPackager getExtensionPackager() {
        return this.extensionPackager;
    }

    public void setup() throws Exception {
        this.copyResourceFolder(this.getLocalRepository(), "repository.local");
        this.copyResourceFolder(this.getMavenRepository(), "repository.maven");
        this.copyResourceFolder(this.getMaven2Repository(), "repository.maven2");
        this.extensionPackager.generateExtensions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copyResourceFolder(File targetFolder, String resourcePackage) throws IOException {
        int nb = 0;
        Collection urls = ClasspathHelper.forPackage((String)resourcePackage, (ClassLoader[])new ClassLoader[0]);
        if (!urls.isEmpty()) {
            String prefix = resourcePackage;
            if (!prefix.endsWith(".")) {
                prefix = prefix + '.';
            }
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new ResourcesScanner()}).setUrls(urls).filterInputsBy((Predicate)new FilterBuilder.Include(FilterBuilder.prefix((String)prefix))));
            for (String resource : reflections.getResources(Pattern.compile(".*"))) {
                targetFolder.mkdirs();
                File targetFile = new File(targetFolder, resource.substring(prefix.length()));
                try (InputStream resourceStream = this.getClass().getResourceAsStream("/" + resource);){
                    FileUtils.copyInputStreamToFile((InputStream)resourceStream, (File)targetFile);
                    ++nb;
                }
            }
        }
        return nb;
    }
}

