/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InvalidExtensionException;
import org.xwiki.extension.internal.PathUtils;
import org.xwiki.extension.repository.internal.ExtensionSerializer;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtension;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtensionFile;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtensionRepository;

public class LocalExtensionStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalExtensionStorage.class);
    private static final String DESCRIPTOR_EXT = "xed";
    private static final String DESCRIPTOR_SUFFIX = ".xed";
    private DefaultLocalExtensionRepository repository;
    private ExtensionSerializer extensionSerializer;
    private File rootFolder;

    public LocalExtensionStorage(DefaultLocalExtensionRepository repository, File rootFolder, ComponentManager componentManager) throws ComponentLookupException {
        this.repository = repository;
        this.rootFolder = rootFolder;
        this.extensionSerializer = (ExtensionSerializer)componentManager.getInstance(ExtensionSerializer.class);
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    protected void loadExtensions() {
        if (this.rootFolder.exists()) {
            this.loadExtensions(this.rootFolder);
        } else {
            this.rootFolder.mkdirs();
        }
    }

    protected void loadExtensions(File folder) {
        for (File child : folder.listFiles()) {
            if (child.isDirectory()) {
                this.loadExtensions(child);
                continue;
            }
            if (!child.getName().endsWith(DESCRIPTOR_SUFFIX)) continue;
            try {
                DefaultLocalExtension localExtension = this.loadDescriptor(child);
                this.repository.addLocalExtension(localExtension);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to load extension from file [" + child + "] in local repository", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultLocalExtension loadDescriptor(File descriptor) throws InvalidExtensionException {
        FileInputStream fis;
        try {
            fis = new FileInputStream(descriptor);
        }
        catch (FileNotFoundException e) {
            throw new InvalidExtensionException("Failed to open descriptor for reading", e);
        }
        try {
            DefaultLocalExtension localExtension = this.extensionSerializer.loadLocalExtensionDescriptor(this.repository, fis);
            localExtension.setDescriptorFile(descriptor);
            localExtension.setFile(this.getFile(descriptor, DESCRIPTOR_EXT, localExtension.getType()));
            if (!localExtension.getFile().getFile().exists()) {
                throw new InvalidExtensionException("Failed to load local extension [" + descriptor + "]: [" + localExtension.getFile() + "] file does not exists");
            }
            DefaultLocalExtension defaultLocalExtension = localExtension;
            return defaultLocalExtension;
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to close stream for file [" + descriptor + "]", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDescriptor(DefaultLocalExtension extension) throws ParserConfigurationException, TransformerException, IOException {
        File file = extension.getDescriptorFile();
        if (file == null) {
            file = this.getNewDescriptorFile(extension.getId());
            extension.setDescriptorFile(file);
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.extensionSerializer.saveExtensionDescriptor(extension, fos);
        }
    }

    protected File getNewExtensionFile(ExtensionId id, String type) {
        return new File(this.getRootFolder(), this.getFilePath(id, type));
    }

    private File getNewDescriptorFile(ExtensionId id) {
        return new File(this.getRootFolder(), this.getFilePath(id, DESCRIPTOR_EXT));
    }

    private File getFile(File baseFile, String baseType, String type) {
        String baseName = this.getBaseName(baseFile.getName(), baseType);
        return new File(baseFile.getParent(), baseName + '.' + PathUtils.encode(type));
    }

    private String getBaseName(String fileName, String type) {
        return fileName.substring(0, fileName.length() - PathUtils.encode(type).length() - 1);
    }

    private String getFilePath(ExtensionId id, String fileExtension) {
        String encodedId = PathUtils.encode(id.getId());
        String encodedVersion = PathUtils.encode(id.getVersion().toString());
        String encodedType = PathUtils.encode(fileExtension);
        return encodedId + File.separator + encodedVersion + File.separator + encodedId + '-' + encodedVersion + '.' + encodedType;
    }

    public void removeExtension(DefaultLocalExtension extension) throws IOException {
        File descriptorFile = extension.getDescriptorFile();
        if (descriptorFile == null) {
            throw new IOException("Exception does not exists");
        }
        descriptorFile.delete();
        DefaultLocalExtensionFile extensionFile = extension.getFile();
        extensionFile.getFile().delete();
    }
}

