/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xwiki.stability.Unstable;

@Unstable
public class ExtensionQuery {
    private String query;
    private int limit = -1;
    private int offset;
    private List<SortClause> sortClauses = new ArrayList<SortClause>();
    private List<Filter> filters = new ArrayList<Filter>();

    public ExtensionQuery() {
    }

    public ExtensionQuery(String query) {
        this.query = query;
    }

    public ExtensionQuery(ExtensionQuery query) {
        this.query = query.getQuery();
        this.setOffset(query.getOffset());
        this.setLimit(query.getLimit());
        this.setSortClauses(query.getSortClauses());
        this.setFilters(query.getFilters());
    }

    public String getQuery() {
        return this.query;
    }

    public ExtensionQuery setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public ExtensionQuery setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public ExtensionQuery setFilters(Collection<Filter> filters) {
        this.filters = new ArrayList<Filter>(filters);
        return this;
    }

    public ExtensionQuery addFilter(String field, Object value, COMPARISON comparison) {
        this.filters.add(new Filter(field, value, comparison));
        return this;
    }

    public ExtensionQuery addFilters(List<Filter> newFilters) {
        this.filters.addAll(newFilters);
        return this;
    }

    public List<SortClause> getSortClauses() {
        return this.sortClauses;
    }

    public ExtensionQuery setSortClauses(Collection<SortClause> sortClauses) {
        this.sortClauses = new ArrayList<SortClause>(sortClauses);
        return this;
    }

    public ExtensionQuery addSort(String field, ORDER order) {
        this.sortClauses.add(new SortClause(field, order));
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public static class Filter {
        private final String field;
        private final Object value;
        private final COMPARISON comparison;

        public Filter(String field, Object value, COMPARISON comparison) {
            this.field = field;
            this.value = value;
            this.comparison = comparison;
        }

        public String getField() {
            return this.field;
        }

        public Object getValue() {
            return this.value;
        }

        public COMPARISON getComparison() {
            return this.comparison;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getField());
            builder.append(' ');
            builder.append((Object)this.getComparison());
            builder.append(' ');
            builder.append(this.getValue());
            return builder.toString();
        }
    }

    public static class SortClause {
        private final String field;
        private final ORDER order;

        public SortClause(String field, ORDER order) {
            this.field = field;
            this.order = order;
        }

        public String getField() {
            return this.field;
        }

        public ORDER getOrder() {
            return this.order;
        }
    }

    public static enum COMPARISON {
        EQUAL,
        MATCH;

    }

    public static enum ORDER {
        DESC,
        ASC;

    }
}

