/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.jar.internal.handler;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.classloader.ClassLoaderManager;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.event.ExtensionUninstalledEvent;
import org.xwiki.extension.handler.ExtensionHandler;
import org.xwiki.extension.handler.ExtensionInitializer;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.job.event.JobFinishedEvent;
import org.xwiki.job.event.JobStartedEvent;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="JarExtensionJobFinishedListener")
public class JarExtensionJobFinishedListener
implements EventListener {
    private static final List<Event> EVENTS = Arrays.asList(new ExtensionUninstalledEvent(), new JobStartedEvent("uninstall"), new JobFinishedEvent("uninstall"));
    @Inject
    private ClassLoaderManager jarExtensionClassLoader;
    @Inject
    private ExtensionInitializer extensionInitializer;
    @Inject
    private InstalledExtensionRepository installedExtensionRepository;
    @Inject
    @Named(value="jar")
    private ExtensionHandler jarHandler;
    @Inject
    private Execution execution;
    @Inject
    private Logger logger;

    public String getName() {
        return "JarExtensionJobFinishedListener";
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    private void pushUninstallLevel() {
        ExecutionContext context = this.execution.getContext();
        if (context != null) {
            Stack<UninstalledExtensionCollection> extensions = this.getUninstalledExtensionCollectionStack(true);
            extensions.push(null);
        }
    }

    private void popUninstallLevel() {
        Stack<UninstalledExtensionCollection> extensions;
        ExecutionContext context = this.execution.getContext();
        if (context != null && (extensions = this.getUninstalledExtensionCollectionStack(false)) != null) {
            extensions.pop();
        }
    }

    private Stack<UninstalledExtensionCollection> getUninstalledExtensionCollectionStack(boolean create) {
        ExecutionContext context = this.execution.getContext();
        if (context != null) {
            Stack extensions = (Stack)context.getProperty("extension.jar.uninstalledExtensions");
            if (extensions == null && create) {
                extensions = new Stack();
                context.setProperty("extension.jar.uninstalledExtensions", extensions);
            }
            return extensions;
        }
        return null;
    }

    private UninstalledExtensionCollection getCurrentJobUninstalledExtensions(boolean create) {
        Stack<UninstalledExtensionCollection> extensions;
        ExecutionContext context = this.execution.getContext();
        if (context != null && (extensions = this.getUninstalledExtensionCollectionStack(false)) != null) {
            UninstalledExtensionCollection collection = extensions.peek();
            if (collection == null && create) {
                collection = new UninstalledExtensionCollection();
                extensions.set(extensions.size() - 1, collection);
            }
            return collection;
        }
        return null;
    }

    private void addUninstalledExtension(ExtensionId id, String namespace) {
        UninstalledExtensionCollection collection = this.getCurrentJobUninstalledExtensions(true);
        if (collection != null) {
            collection.add(namespace);
        }
    }

    public void onEvent(Event event, Object o, Object o1) {
        if (event instanceof ExtensionUninstalledEvent) {
            this.onExtensionUninstalledEvent(event);
        } else if (event instanceof JobStartedEvent) {
            this.onJobStartedEvent(event);
        } else {
            this.onJobFinishedEvent(event);
        }
    }

    private void onExtensionUninstalledEvent(Event event) {
        ExtensionUninstalledEvent uninstallEvent = (ExtensionUninstalledEvent)event;
        this.addUninstalledExtension(uninstallEvent.getExtensionId(), uninstallEvent.getNamespace());
    }

    private void onJobStartedEvent(Event event) {
        this.pushUninstallLevel();
    }

    private void onJobFinishedEvent(Event event) {
        UninstalledExtensionCollection collection = this.getCurrentJobUninstalledExtensions(false);
        this.popUninstallLevel();
        if (collection != null) {
            if (collection.rootNamespace) {
                this.unloadJARsFromNamespace(null, null);
                this.jarExtensionClassLoader.dropURLClassLoaders();
                this.extensionInitializer.initialize(null, "jar");
            } else if (collection.namespaces != null) {
                for (String namespace : collection.namespaces) {
                    this.unloadJARsFromNamespace(namespace, null);
                    this.jarExtensionClassLoader.dropURLClassLoader(namespace);
                    this.extensionInitializer.initialize(namespace, "jar");
                }
            }
        }
    }

    private void unloadJARsFromNamespace(String namespace, Map<String, Set<InstalledExtension>> unloadedExtensions) {
        if (unloadedExtensions == null) {
            unloadedExtensions = new HashMap<String, Set<InstalledExtension>>();
        }
        Collection installedExtensions = namespace != null ? this.installedExtensionRepository.getInstalledExtensions(namespace) : this.installedExtensionRepository.getInstalledExtensions();
        for (InstalledExtension installedExtension : installedExtensions) {
            if (!"jar".equals(installedExtension.getType()) || namespace != null && installedExtension.isInstalled(null)) continue;
            try {
                this.unloadJAR(installedExtension, namespace, unloadedExtensions);
            }
            catch (Exception e) {
                this.logger.error("Failed to unload installed extension [{}]", (Object)installedExtension, (Object)e);
            }
        }
    }

    private void unloadJAR(InstalledExtension installedExtension, String namespace, Map<String, Set<InstalledExtension>> unloadedExtensions) throws UninstallException {
        Set<InstalledExtension> unloadedExtensionsInNamespace = unloadedExtensions.get(namespace);
        if (unloadedExtensionsInNamespace == null) {
            unloadedExtensionsInNamespace = new HashSet<InstalledExtension>();
            unloadedExtensions.put(namespace, unloadedExtensionsInNamespace);
        }
        if (!unloadedExtensionsInNamespace.contains(installedExtension)) {
            if (namespace == null) {
                if (installedExtension.isInstalled(null)) {
                    try {
                        Map bDependencies = this.installedExtensionRepository.getBackwardDependencies(installedExtension.getId());
                        for (Map.Entry entry : bDependencies.entrySet()) {
                            for (InstalledExtension bDependency : (Collection)entry.getValue()) {
                                this.unloadJAR(bDependency, (String)entry.getKey(), unloadedExtensions);
                            }
                        }
                    }
                    catch (ResolveException e) {
                        this.logger.error("Failed to get backward dependencies for installed extension [{}]", (Object)installedExtension, (Object)e);
                    }
                    this.jarHandler.uninstall(installedExtension, null, null);
                    unloadedExtensionsInNamespace.add(installedExtension);
                } else {
                    for (String namespace2 : installedExtension.getNamespaces()) {
                        this.unloadJAR(installedExtension, namespace2, unloadedExtensions);
                    }
                }
            } else {
                try {
                    Collection bDependencies = this.installedExtensionRepository.getBackwardDependencies(installedExtension.getId().getId(), namespace);
                    for (InstalledExtension bDependency : bDependencies) {
                        this.unloadJAR(bDependency, namespace, unloadedExtensions);
                    }
                }
                catch (ResolveException e) {
                    this.logger.error("Failed to get backward dependencies for installed extension [{}] on namespace [{}]", new Object[]{installedExtension, namespace, e});
                }
                this.jarHandler.uninstall(installedExtension, namespace, null);
                unloadedExtensionsInNamespace.add(installedExtension);
            }
        }
    }

    private static final class UninstalledExtensionCollection {
        boolean rootNamespace = false;
        public Set<String> namespaces;

        private UninstalledExtensionCollection() {
        }

        public void add(String namespace) {
            if (!this.rootNamespace) {
                if (namespace != null) {
                    if (this.namespaces == null) {
                        this.namespaces = new HashSet<String>();
                    }
                    this.namespaces.add(namespace);
                } else {
                    this.rootNamespace = true;
                }
            }
        }
    }
}

