/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.http.internal;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionManagerConfiguration;
import org.xwiki.extension.repository.http.internal.HttpClientFactory;

@Component
@Singleton
public class DefaultHttpClientFactory
implements HttpClientFactory {
    @Inject
    private ExtensionManagerConfiguration configuration;

    @Override
    public CloseableHttpClient createClient(String user, String password) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.useSystemProperties();
        httpClientBuilder.setUserAgent(this.configuration.getUserAgent());
        BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager();
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(60000).build();
        connectionManager.setSocketConfig(socketConfig);
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        if (user != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, password));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        return httpClientBuilder.build();
    }
}

