/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.config.LRUCacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.job.GroupedJobInitializer;
import org.xwiki.job.GroupedJobInitializerManager;
import org.xwiki.job.JobGroupPath;
import org.xwiki.job.JobManagerConfiguration;

@Component
@Singleton
public class DefaultGroupedJobInitializerManager
implements GroupedJobInitializerManager,
Initializable {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private Logger logger;
    @Inject
    private GroupedJobInitializer defaultGoupedJobInitializer;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private JobManagerConfiguration configuration;
    private Cache<GroupedJobInitializer> cachedInitializers;

    public void initialize() throws InitializationException {
        if (this.cachedInitializers == null) {
            LRUCacheConfiguration cacheConfiguration = new LRUCacheConfiguration("job.grouped.initializer", this.configuration.getGroupedJobInitializerCacheSize());
            try {
                this.cachedInitializers = this.cacheManager.createNewCache((CacheConfiguration)cacheConfiguration);
            }
            catch (CacheException e) {
                throw new InitializationException("Error while creating cache for GroupedJobInitializer", (Throwable)e);
            }
        }
    }

    private GroupedJobInitializer search(JobGroupPath path, List<GroupedJobInitializer> initializers) {
        GroupedJobInitializer result = (GroupedJobInitializer)this.cachedInitializers.get(path.toString());
        if (result == null) {
            for (GroupedJobInitializer initializer : initializers) {
                if (initializer.getId() == null) continue;
                this.cachedInitializers.set(initializer.getId().toString(), (Object)initializer);
                if (!path.equals((Object)initializer.getId())) continue;
                result = initializer;
                break;
            }
        }
        return result;
    }

    public GroupedJobInitializer getGroupedJobInitializer(JobGroupPath jobGroupPath) {
        GroupedJobInitializer result = null;
        if (jobGroupPath != null && (result = (GroupedJobInitializer)this.cachedInitializers.get(jobGroupPath.toString())) == null) {
            try {
                List initializers = ((ComponentManager)this.componentManagerProvider.get()).getInstanceList(GroupedJobInitializer.class);
                for (JobGroupPath currentPath = jobGroupPath; currentPath != null && result == null; currentPath = currentPath.getParent()) {
                    result = this.search(currentPath, initializers);
                }
            }
            catch (ComponentLookupException e) {
                this.logger.error("Error while loading GroupedJobInitializer component: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        if (result == null) {
            result = this.defaultGoupedJobInitializer;
        }
        if (jobGroupPath != null) {
            this.cachedInitializers.set(jobGroupPath.toString(), (Object)result);
        }
        return result;
    }

    public void invalidateCache() {
        this.cachedInitializers.removeAll();
    }
}

