/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.xwiki.job.Request;
import org.xwiki.job.event.status.JobProgress;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.job.internal.DefaultJobProgress;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.LogQueue;
import org.xwiki.logging.LoggerManager;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.logging.event.LogQueueListener;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;

public abstract class AbstractJobStatus<R extends Request>
implements JobStatus {
    private transient ObservationManager observationManager;
    private transient LoggerManager loggerManager;
    private JobStatus.State state = JobStatus.State.NONE;
    private R request;
    private LogQueue logs = new LogQueue();
    private Date startDate;
    private Date endDate;
    private final transient ReentrantLock askLock = new ReentrantLock();
    private final transient Condition answered = this.askLock.newCondition();
    private volatile transient Object question;
    private transient DefaultJobProgress progress;

    public AbstractJobStatus(R request, ObservationManager observationManager, LoggerManager loggerManager) {
        this.request = request;
        this.observationManager = observationManager;
        this.loggerManager = loggerManager;
        this.progress = new DefaultJobProgress();
    }

    public void startListening() {
        this.observationManager.addListener((EventListener)this.progress);
        this.loggerManager.pushLogListener((EventListener)new LogQueueListener(LogQueueListener.class.getName() + '_' + this.hashCode(), this.logs));
    }

    public void stopListening() {
        this.loggerManager.popLogListener();
        this.observationManager.removeListener(this.progress.getName());
    }

    @Override
    public JobStatus.State getState() {
        return this.state;
    }

    public void setState(JobStatus.State state) {
        this.state = state;
    }

    public R getRequest() {
        return this.request;
    }

    @Override
    public LogQueue getLog() {
        return this.logs;
    }

    @Override
    public List<LogEvent> getLog(LogLevel level) {
        ArrayList<LogEvent> levelLogs = new ArrayList<LogEvent>();
        for (LogEvent log : this.logs) {
            if (log.getLevel() != level) continue;
            levelLogs.add(log);
        }
        return levelLogs;
    }

    @Override
    public JobProgress getProgress() {
        return this.progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ask(Object question) throws InterruptedException {
        this.question = question;
        this.askLock.lockInterruptibly();
        try {
            this.state = JobStatus.State.WAITING;
            this.answered.await();
            this.state = JobStatus.State.RUNNING;
        }
        finally {
            this.askLock.unlock();
        }
    }

    @Override
    public Object getQuestion() {
        return this.question;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void answered() {
        this.askLock.lock();
        this.question = null;
        try {
            this.answered.signal();
        }
        finally {
            this.askLock.unlock();
        }
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
}

