/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import com.thoughtworks.xstream.MarshallingStrategy;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.core.TreeMarshallingStrategy;
import com.thoughtworks.xstream.core.TreeUnmarshaller;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.job.JobManagerConfiguration;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.job.internal.JobStatusStorage;
import org.xwiki.job.internal.xstream.SafeArrayConverter;
import org.xwiki.job.internal.xstream.SafeTreeUnmarshaller;

@Component
@Singleton
public class DefaultJobStatusStorage
implements JobStatusStorage,
Initializable {
    private static final String FILENAME_STATUS = "status.xml";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String FOLDER_NULL = "&null";
    private static final String FOLDER_STATUS = "&status";
    @Inject
    private JobManagerConfiguration configuration;
    @Inject
    private Logger logger;
    private XStream xstream;
    private Map<List<String>, JobStatus> jobs = new ConcurrentHashMap<List<String>, JobStatus>();

    public void initialize() throws InitializationException {
        this.xstream = new XStream(){

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return new MapperWrapper((Mapper)next){

                    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                        return definedIn != Object.class ? super.shouldSerializeMember(definedIn, fieldName) : false;
                    }
                };
            }
        };
        this.xstream.registerConverter((Converter)new SafeArrayConverter(this.xstream.getMapper()));
        this.xstream.setMarshallingStrategy((MarshallingStrategy)new TreeMarshallingStrategy(){

            protected TreeUnmarshaller createUnmarshallingContext(Object root, HierarchicalStreamReader reader, ConverterLookup converterLookup, Mapper mapper) {
                return new SafeTreeUnmarshaller(root, reader, converterLookup, mapper);
            }
        });
        try {
            this.load();
        }
        catch (Exception e) {
            this.logger.error("Failed to load jobs", (Throwable)e);
        }
    }

    private String encode(String name) {
        String encoded;
        if (name != null) {
            try {
                encoded = URLEncoder.encode(name, DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                encoded = name;
            }
        } else {
            encoded = FOLDER_NULL;
        }
        return encoded;
    }

    private void load() {
        File folder = this.configuration.getStorage();
        if (folder.exists()) {
            this.loadFolder(folder);
        }
    }

    private void loadFolder(File folder) {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                if (file.getName().equals(FOLDER_STATUS)) {
                    this.loadStatus(file);
                    continue;
                }
                this.loadFolder(file);
                continue;
            }
            if (!file.getName().equals(FILENAME_STATUS)) continue;
            this.loadStatus(folder);
        }
    }

    private void loadStatus(File folder) {
        File statusFile = new File(folder, FILENAME_STATUS);
        if (statusFile.exists()) {
            try {
                JobStatus status = this.loadJobStatus(statusFile);
                List<String> id = status.getRequest().getId();
                this.jobs.put(id != null ? id : Collections.emptyList(), status);
            }
            catch (Throwable e) {
                this.logger.error("Failed to load job status from file [{}]", (Object)statusFile, (Object)e);
            }
        }
    }

    private JobStatus loadJobStatus(File statusFile) throws Exception {
        return (JobStatus)this.xstream.fromXML(statusFile);
    }

    private File getJobFolder(List<String> id) {
        File folder = this.configuration.getStorage();
        for (String idElement : id) {
            folder = new File(folder, this.encode(idElement));
        }
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveJobStatus(JobStatus status) throws IOException {
        File statusFile = this.getJobFolder(status.getRequest().getId());
        statusFile = new File(statusFile, FILENAME_STATUS);
        FileOutputStream stream = FileUtils.openOutputStream((File)statusFile);
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, DEFAULT_ENCODING);
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            this.xstream.toXML((Object)status, (Writer)writer);
            writer.flush();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)stream);
        }
    }

    @Override
    public JobStatus getJobStatus(String id) {
        return this.getJobStatus(id != null ? Arrays.asList(id) : (List<String>)null);
    }

    @Override
    public JobStatus getJobStatus(List<String> id) {
        return this.jobs.get(id != null ? id : Collections.EMPTY_LIST);
    }

    @Override
    public void store(JobStatus status) {
        this.jobs.put(status.getRequest().getId(), status);
        if (status instanceof Serializable) {
            try {
                this.saveJobStatus(status);
            }
            catch (Exception e) {
                this.logger.warn("Failed to save job status [{}]", (Object)status, (Object)e);
            }
        }
    }

    @Override
    public JobStatus remove(String id) {
        return this.remove(Arrays.asList(id));
    }

    @Override
    public JobStatus remove(List<String> id) {
        JobStatus status = this.jobs.remove(id);
        File jobFolder = this.getJobFolder(id);
        if (jobFolder.exists()) {
            try {
                FileUtils.deleteDirectory((File)jobFolder);
            }
            catch (IOException e) {
                this.logger.warn("Failed to delete job folder [{}]", (Object)jobFolder, (Object)e);
            }
        }
        return status;
    }
}

