/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import com.thoughtworks.xstream.MarshallingStrategy;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.core.TreeMarshallingStrategy;
import com.thoughtworks.xstream.core.TreeUnmarshaller;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.job.internal.xstream.SafeArrayConverter;
import org.xwiki.job.internal.xstream.SafeTreeUnmarshaller;

public class JobStatusSerializer {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private XStream xstream = new XStream();

    public JobStatusSerializer() throws ParserConfigurationException {
        this.xstream.ignoreUnknownElements();
        this.xstream.registerConverter((Converter)new SafeArrayConverter(this.xstream.getMapper(), this.xstream));
        this.xstream.setMarshallingStrategy((MarshallingStrategy)new TreeMarshallingStrategy(){

            protected TreeUnmarshaller createUnmarshallingContext(Object root, HierarchicalStreamReader reader, ConverterLookup converterLookup, Mapper mapper) {
                return new SafeTreeUnmarshaller(root, reader, converterLookup, mapper);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(JobStatus status, File file) throws IOException {
        FileOutputStream stream = FileUtils.openOutputStream((File)file);
        try {
            this.write(status, stream);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)stream);
        }
    }

    public void write(JobStatus status, OutputStream stream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(stream, DEFAULT_ENCODING);
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.xstream.toXML((Object)status, (Writer)writer);
        writer.flush();
    }

    public JobStatus read(File file) {
        return (JobStatus)this.xstream.fromXML(file);
    }

    public JobStatus read(InputStream stream) {
        return (JobStatus)this.xstream.fromXML(stream);
    }
}

