/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.ReferencingMarshallingContext;
import com.thoughtworks.xstream.core.util.ArrayIterator;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.job.internal.xstream.DataHolderWrapper;
import org.xwiki.job.internal.xstream.SafeTreeMarshaller;
import org.xwiki.job.internal.xstream.VoidWriter;
import org.xwiki.job.internal.xstream.XStreamUtils;

public class SafeReflectionConverter
extends ReflectionConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeTreeMarshaller.class);
    private final XStream xstream;

    public SafeReflectionConverter(XStream xstream) {
        super(xstream.getMapper(), xstream.getReflectionProvider());
        this.xstream = xstream;
    }

    protected void doMarshal(final Object source, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        final ArrayList fields = new ArrayList();
        final HashMap defaultFieldDefinition = new HashMap();
        this.reflectionProvider.visitSerializableFields(source, new ReflectionProvider.Visitor(){
            final Set writtenAttributes = new HashSet();

            public void visit(String fieldName, Class type, Class definedIn, Object value) {
                SingleValueConverter converter;
                if (!SafeReflectionConverter.this.mapper.shouldSerializeMember(definedIn, fieldName)) {
                    return;
                }
                if (!defaultFieldDefinition.containsKey(fieldName)) {
                    Class lookupType = source.getClass();
                    if (definedIn != source.getClass() && !SafeReflectionConverter.this.mapper.shouldSerializeMember(lookupType, fieldName)) {
                        lookupType = definedIn;
                    }
                    defaultFieldDefinition.put(fieldName, SafeReflectionConverter.this.reflectionProvider.getField(lookupType, fieldName));
                }
                if ((converter = SafeReflectionConverter.this.mapper.getConverterFromItemType(fieldName, type, definedIn)) != null) {
                    String attribute = SafeReflectionConverter.this.mapper.aliasForAttribute(SafeReflectionConverter.this.mapper.serializedMember(definedIn, fieldName));
                    if (value != null) {
                        if (this.writtenAttributes.contains(fieldName)) {
                            throw new ConversionException("Cannot write field with name '" + fieldName + "' twice as attribute for object of type " + source.getClass().getName());
                        }
                        String str = converter.toString(value);
                        if (str != null) {
                            writer.addAttribute(attribute, str);
                        }
                    }
                    this.writtenAttributes.add(fieldName);
                } else {
                    fields.add(new FieldInfo(fieldName, type, definedIn, value));
                }
            }
        });
        new Object(){
            {
                for (FieldInfo info : fields) {
                    if (info.value == null) continue;
                    Mapper.ImplicitCollectionMapping mapping = SafeReflectionConverter.this.mapper.getImplicitCollectionDefForFieldName(source.getClass(), info.fieldName);
                    if (mapping != null) {
                        Object iter;
                        if (context instanceof ReferencingMarshallingContext && info.value != Collections.EMPTY_LIST && info.value != Collections.EMPTY_SET && info.value != Collections.EMPTY_MAP) {
                            ReferencingMarshallingContext refContext = (ReferencingMarshallingContext)context;
                            refContext.registerImplicit(info.value);
                        }
                        boolean isCollection = info.value instanceof Collection;
                        boolean isMap = info.value instanceof Map;
                        boolean isEntry = isMap && mapping.getKeyFieldName() == null;
                        boolean isArray = info.value.getClass().isArray();
                        Object object2 = isArray ? new ArrayIterator(info.value) : (isCollection ? ((Collection)info.value).iterator() : (iter = isEntry ? ((Map)info.value).entrySet().iterator() : ((Map)info.value).values().iterator()));
                        while (iter.hasNext()) {
                            String itemName;
                            Class<?> itemType;
                            Object obj = iter.next();
                            if (obj == null) {
                                itemType = Object.class;
                                itemName = SafeReflectionConverter.this.mapper.serializedClass(null);
                            } else {
                                if (isEntry) {
                                    String entryName = mapping.getItemFieldName() != null ? mapping.getItemFieldName() : SafeReflectionConverter.this.mapper.serializedClass(Map.Entry.class);
                                    Map.Entry entry = (Map.Entry)obj;
                                    ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)entryName, entry.getClass());
                                    this.writeItem(entry.getKey(), context, writer);
                                    this.writeItem(entry.getValue(), context, writer);
                                    writer.endNode();
                                    continue;
                                }
                                if (mapping.getItemFieldName() != null) {
                                    itemType = mapping.getItemType();
                                    itemName = mapping.getItemFieldName();
                                } else {
                                    itemType = obj.getClass();
                                    itemName = SafeReflectionConverter.this.mapper.serializedClass(itemType);
                                }
                            }
                            this.safeWriteField(info.fieldName, itemName, itemType, info.definedIn, obj);
                        }
                        continue;
                    }
                    this.safeWriteField(info.fieldName, null, info.type, info.definedIn, info.value);
                }
            }

            void safeWriteField(String fieldName, String aliasName, Class fieldType, Class definedIn, Object newObj) {
                if (XStreamUtils.isSafeType(newObj)) {
                    this.writeField(fieldName, aliasName, fieldType, definedIn, newObj);
                } else {
                    try {
                        SafeReflectionConverter.this.xstream.marshal(newObj, (HierarchicalStreamWriter)VoidWriter.WRITER, (DataHolder)new DataHolderWrapper((DataHolder)context));
                        this.writeField(fieldName, aliasName, fieldType, definedIn, newObj);
                    }
                    catch (Throwable e) {
                        LOGGER.debug("Failed to write field [" + fieldName + "], ignore", e);
                    }
                }
            }

            void writeField(String fieldName, String aliasName, Class fieldType, Class definedIn, Object newObj) {
                Class<?> actualType = newObj != null ? newObj.getClass() : fieldType;
                ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)(aliasName != null ? aliasName : SafeReflectionConverter.this.mapper.serializedMember(source.getClass(), fieldName)), actualType);
                if (newObj != null) {
                    Field defaultField;
                    String attributeName;
                    String serializedClassName;
                    Class defaultType = SafeReflectionConverter.this.mapper.defaultImplementationOf(fieldType);
                    if (!actualType.equals(defaultType) && !(serializedClassName = SafeReflectionConverter.this.mapper.serializedClass(actualType)).equals(SafeReflectionConverter.this.mapper.serializedClass(defaultType)) && (attributeName = SafeReflectionConverter.this.mapper.aliasForSystemAttribute("class")) != null) {
                        writer.addAttribute(attributeName, serializedClassName);
                    }
                    if ((defaultField = (Field)defaultFieldDefinition.get(fieldName)).getDeclaringClass() != definedIn && (attributeName = SafeReflectionConverter.this.mapper.aliasForSystemAttribute("defined-in")) != null) {
                        writer.addAttribute(attributeName, SafeReflectionConverter.this.mapper.serializedClass(definedIn));
                    }
                    Field field = SafeReflectionConverter.this.reflectionProvider.getField(definedIn, fieldName);
                    SafeReflectionConverter.this.marshallField(context, newObj, field);
                }
                writer.endNode();
            }

            void writeItem(Object item, MarshallingContext context2, HierarchicalStreamWriter writer2) {
                if (item == null) {
                    String name = SafeReflectionConverter.this.mapper.serializedClass(null);
                    ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer2, (String)name, Mapper.Null.class);
                    writer2.endNode();
                } else {
                    String name = SafeReflectionConverter.this.mapper.serializedClass(item.getClass());
                    ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer2, (String)name, item.getClass());
                    context2.convertAnother(item);
                    writer2.endNode();
                }
            }
        };
    }

    private static class FieldInfo {
        final String fieldName;
        final Class type;
        final Class definedIn;
        final Object value;

        FieldInfo(String fieldName, Class type, Class definedIn, Object value) {
            this.fieldName = fieldName;
            this.type = type;
            this.definedIn = definedIn;
            this.value = value;
        }
    }
}

