/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal.xstream;

import java.util.Arrays;
import java.util.List;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;

public final class XStreamUtils {
    private static final List<Class<?>> UNSERIALIZABLE_CLASSES = Arrays.asList(Provider.class, ComponentManager.class);

    private XStreamUtils() {
    }

    public static boolean isSafeType(Object obj) {
        return obj == null || obj instanceof String || obj instanceof Number || obj.getClass().isArray() || obj instanceof Enum;
    }

    public static boolean isComponent(Object item) {
        if (item != null) {
            if (item.getClass().isAnnotationPresent(Component.class)) {
                return true;
            }
            for (Class<?> clazz : UNSERIALIZABLE_CLASSES) {
                if (!clazz.isInstance(item)) continue;
                return true;
            }
        }
        return false;
    }
}

