/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.JobManager;
import org.xwiki.job.Request;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.job.internal.JobStatusStorage;

@Component
@Singleton
public class DefaultJobManager
implements JobManager,
Runnable,
Initializable {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManager;
    @Inject
    private JobStatusStorage storage;
    @Inject
    private Execution execution;
    @Inject
    private ExecutionContextManager executionContextManager;
    private volatile Job currentJob;
    private BlockingQueue<Job> jobQueue = new LinkedBlockingQueue<Job>();
    private Thread thread;

    public void initialize() throws InitializationException {
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.start();
        this.thread.setName("Job Manager daemon thread");
    }

    @Override
    public void run() {
        while (!this.thread.isInterrupted()) {
            this.runJob();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runJob() {
        try {
            this.currentJob = this.jobQueue.take();
            ExecutionContext context = new ExecutionContext();
            try {
                this.executionContextManager.initialize(context);
            }
            catch (ExecutionContextException e) {
                throw new RuntimeException("Failed to initialize Job " + this.currentJob + " execution context", e);
            }
            this.currentJob.run();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.execution.removeContext();
        }
    }

    @Override
    public Job getCurrentJob() {
        return this.currentJob;
    }

    private Job createJob(String jobType) throws JobException {
        Job job;
        try {
            job = (Job)((ComponentManager)this.componentManager.get()).getInstance(Job.class, jobType);
        }
        catch (ComponentLookupException e) {
            throw new JobException("Failed to lookup any Job for role hint [" + jobType + "]", e);
        }
        return job;
    }

    @Override
    public Job executeJob(String jobType, Request request) throws JobException {
        Job job = this.addJob(jobType, request);
        try {
            job.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return job;
    }

    @Override
    public Job addJob(String jobType, Request request) throws JobException {
        Job job = this.createJob(jobType);
        job.initialize(request);
        this.jobQueue.offer(job);
        return job;
    }

    @Override
    public void addJob(Job job) {
        this.jobQueue.offer(job);
    }

    @Override
    public JobStatus getJobStatus(String id) {
        return this.getJobStatus(Arrays.asList(id));
    }

    @Override
    public JobStatus getJobStatus(List<String> id) {
        if (this.currentJob != null && Objects.equals(id, this.currentJob.getRequest().getId())) {
            return this.currentJob.getStatus();
        }
        for (Job job : this.jobQueue) {
            if (!Objects.equals(id, job.getRequest().getId())) continue;
            return job.getStatus();
        }
        return this.storage.getJobStatus(id);
    }
}

