/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.job.JobManagerConfiguration;
import org.xwiki.job.JobStatusStore;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.job.internal.DefaultJobStatus;
import org.xwiki.job.internal.JobStatusSerializer;

@Component
@Singleton
public class DefaultJobStatusStore
implements JobStatusStore,
Initializable {
    private static final String FILENAME_STATUS = "status.xml";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String FOLDER_NULL = "&null";
    private static final JobStatus NOSTATUS = new DefaultJobStatus<Object>(null, null, null, false);
    @Inject
    private JobManagerConfiguration configuration;
    @Inject
    private Logger logger;
    private JobStatusSerializer serializer;
    private ExecutorService executorService;
    private Map<List<String>, JobStatus> cache;

    public void initialize() throws InitializationException {
        try {
            this.serializer = new JobStatusSerializer();
            this.repair();
        }
        catch (Exception e) {
            this.logger.error("Failed to load jobs", (Throwable)e);
        }
        BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("Job status serializer").daemon(true).priority(1).build();
        this.executorService = new ThreadPoolExecutor(0, 10, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)threadFactory);
        this.cache = Collections.synchronizedMap(new Cache(50));
    }

    private String encode(String name) {
        String encoded;
        if (name != null) {
            try {
                encoded = URLEncoder.encode(name, DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                encoded = name;
            }
        } else {
            encoded = FOLDER_NULL;
        }
        return encoded;
    }

    private void repair() {
        File folder = this.configuration.getStorage();
        if (folder.exists()) {
            this.repairFolder(folder);
        }
    }

    private void repairFolder(File folder) {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                this.repairFolder(file);
                continue;
            }
            if (!file.getName().equals(FILENAME_STATUS)) continue;
            try {
                File properFolder;
                JobStatus status = this.loadStatus(folder);
                if (status == null || folder.equals(properFolder = this.getJobFolder(status.getRequest().getId()))) continue;
                try {
                    FileUtils.moveFileToDirectory((File)file, (File)properFolder, (boolean)true);
                }
                catch (IOException e) {
                    this.logger.error("Failed to move job status file", (Throwable)e);
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to load job status in folder [{}]", (Object)folder, (Object)e);
            }
        }
    }

    private JobStatus loadStatus(List<String> id) {
        return this.loadStatus(this.getJobFolder(id));
    }

    private JobStatus loadStatus(File folder) {
        File statusFile = new File(folder, FILENAME_STATUS);
        if (statusFile.exists()) {
            return this.loadJobStatus(statusFile);
        }
        return null;
    }

    private JobStatus loadJobStatus(File statusFile) {
        return this.serializer.read(statusFile);
    }

    private File getJobFolder(List<String> id) {
        File folder = this.configuration.getStorage();
        if (id != null) {
            for (String idElement : id) {
                folder = new File(folder, this.encode(idElement));
            }
        }
        return folder;
    }

    private void saveJobStatus(JobStatus status) {
        try {
            File statusFile = this.getJobFolder(status.getRequest().getId());
            statusFile = new File(statusFile, FILENAME_STATUS);
            this.serializer.write(status, statusFile);
        }
        catch (Exception e) {
            this.logger.warn("Failed to save job status [{}]", (Object)status, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobStatus getJobStatus(List<String> id) {
        JobStatus status = this.cache.get(id);
        if (status == null) {
            Map<List<String>, JobStatus> map = this.cache;
            synchronized (map) {
                status = this.cache.get(id);
                if (status == null) {
                    try {
                        status = this.loadStatus(id);
                        this.cache.put(id, status);
                    }
                    catch (Exception e) {
                        this.logger.warn("Failed to load job status for id [{}]", id, (Object)e);
                        this.cache.put(id, null);
                    }
                }
            }
        }
        return status == NOSTATUS ? null : status;
    }

    @Override
    public void store(JobStatus status) {
        this.store(status, false);
    }

    @Override
    public void storeAsync(JobStatus status) {
        this.store(status, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(JobStatus status, boolean async) {
        if (status != null && status.getRequest() != null && status.getRequest().getId() != null) {
            Map<List<String>, JobStatus> map = this.cache;
            synchronized (map) {
                this.cache.put(status.getRequest().getId(), status);
            }
            if (status.getClass().isAnnotationPresent(org.xwiki.job.annotation.Serializable.class) || status instanceof Serializable) {
                if (async) {
                    this.executorService.execute(new JobStatusSerializerRunnable(status));
                } else {
                    this.saveJobStatus(status);
                }
            }
        }
    }

    @Override
    public void remove(List<String> id) {
        File jobFolder = this.getJobFolder(id);
        if (jobFolder.exists()) {
            try {
                FileUtils.deleteDirectory((File)jobFolder);
            }
            catch (IOException e) {
                this.logger.warn("Failed to delete job folder [{}]", (Object)jobFolder, (Object)e);
            }
            this.cache.remove(id);
        }
        this.cache.remove(id);
    }

    class JobStatusSerializerRunnable
    implements Runnable {
        private final JobStatus status;

        public JobStatusSerializerRunnable(JobStatus status) {
            this.status = status;
        }

        @Override
        public void run() {
            DefaultJobStatusStore.this.saveJobStatus(this.status);
        }
    }

    private static class Cache
    implements Map<List<String>, JobStatus> {
        private final Map<List<String>, JobStatus> cache;
        private final Set<List<String>> noStatusCache;

        public Cache(int size) {
            this.cache = new LRUMap(size);
            this.noStatusCache = new HashSet<List<String>>();
        }

        @Override
        public int size() {
            return this.cache.size() + this.noStatusCache.size();
        }

        @Override
        public boolean isEmpty() {
            return this.cache.isEmpty() && this.noStatusCache.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.cache.containsKey(key) || this.noStatusCache.contains(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public JobStatus get(Object key) {
            if (!this.noStatusCache.contains(key)) {
                return this.cache.get(key);
            }
            return NOSTATUS;
        }

        @Override
        public JobStatus put(List<String> key, JobStatus value) {
            JobStatus status = this.get(key);
            if (value == null) {
                this.cache.remove(key);
                this.noStatusCache.add(key);
            } else {
                this.cache.put(key, value);
                this.noStatusCache.remove(key);
            }
            return status;
        }

        @Override
        public JobStatus remove(Object key) {
            JobStatus status = this.get(key);
            this.cache.remove(key);
            this.noStatusCache.remove(key);
            return status;
        }

        @Override
        public void putAll(Map<? extends List<String>, ? extends JobStatus> m) {
            for (Map.Entry<? extends List<String>, ? extends JobStatus> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void clear() {
            this.cache.clear();
            this.noStatusCache.clear();
        }

        @Override
        public Set<List<String>> keySet() {
            return null;
        }

        @Override
        public Collection<JobStatus> values() {
            return null;
        }

        @Override
        public Set<Map.Entry<List<String>, JobStatus>> entrySet() {
            return null;
        }
    }
}

