/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.job.internal.xstream;

import org.xwiki.component.annotation.Component;
import org.xwiki.job.annotation.Serializable;

/**
 * Various XStream related utilities.
 *
 * @version $Id: 061a30a287c8d00617860c3791dabcaa6e43dda9 $
 * @since 5.4M1
 */
public final class XStreamUtils
{
    private XStreamUtils()
    {

    }

    /**
     * @param obj the value to check
     * @return true if the type serialization cannot fail
     */
    public static boolean isSafeType(Object obj)
    {
        return obj == null || obj instanceof String || obj instanceof Number || obj.getClass().isArray()
            || obj instanceof Enum;
    }

    /**
     * @param item the item to serialize
     * @return true of the item looks like a component
     */
    public static boolean isSerializable(Object item)
    {
        if (item != null) {
            return item.getClass().isAnnotationPresent(Serializable.class) || item instanceof java.io.Serializable
                || !item.getClass().isAnnotationPresent(Component.class);
        }

        return false;
    }
}
