/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.xwiki.job.Request;
import org.xwiki.job.event.status.JobProgress;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.job.event.status.QuestionAnsweredEvent;
import org.xwiki.job.event.status.QuestionAskedEvent;
import org.xwiki.job.internal.DefaultJobProgress;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.LogQueue;
import org.xwiki.logging.Logger;
import org.xwiki.logging.LoggerManager;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.logging.event.LoggerListener;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.WrappedThreadEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.stability.Unstable;

public abstract class AbstractJobStatus<R extends Request>
implements JobStatus {
    private final transient ReentrantLock askLock = new ReentrantLock();
    private final transient Condition answered = this.askLock.newCondition();
    private final transient ObservationManager observationManager;
    private final transient LoggerManager loggerManager;
    private volatile transient Object question;
    private transient LoggerListener logListener;
    private final DefaultJobProgress progress = new DefaultJobProgress();
    private LogQueue logs;
    private JobStatus.State state = JobStatus.State.NONE;
    private R request;
    private Date startDate;
    private Date endDate;
    private JobStatus parentJobStatus;
    private boolean isolated = true;

    public AbstractJobStatus(R request, ObservationManager observationManager, LoggerManager loggerManager, JobStatus parentJobStatus) {
        this.request = request;
        this.observationManager = observationManager;
        this.loggerManager = loggerManager;
        this.parentJobStatus = parentJobStatus;
        this.isolated = parentJobStatus == null;
        this.logs = new LogQueue();
    }

    public void startListening() {
        this.observationManager.addListener((EventListener)new WrappedThreadEventListener((EventListener)this.progress));
        this.logListener = new LoggerListener(LoggerListener.class.getName() + '_' + this.hashCode(), (Logger)this.logs);
        if (this.isIsolated()) {
            this.loggerManager.pushLogListener((EventListener)this.logListener);
        } else {
            this.observationManager.addListener((EventListener)new WrappedThreadEventListener((EventListener)this.logListener));
        }
    }

    public void stopListening() {
        if (this.isIsolated()) {
            this.loggerManager.popLogListener();
        } else {
            this.observationManager.removeListener(this.logListener.getName());
        }
        this.observationManager.removeListener(this.progress.getName());
        this.progress.getRootStep().finish();
    }

    @Override
    public JobStatus.State getState() {
        return this.state;
    }

    public void setState(JobStatus.State state) {
        this.state = state;
    }

    public R getRequest() {
        return this.request;
    }

    @Override
    public LogQueue getLog() {
        if (this.logs == null) {
            this.logs = new LogQueue();
        }
        return this.logs;
    }

    @Override
    public JobProgress getProgress() {
        return this.progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ask(Object question) throws InterruptedException {
        this.question = question;
        this.askLock.lockInterruptibly();
        try {
            this.state = JobStatus.State.WAITING;
            if (this.isSubJob()) {
                this.parentJobStatus.ask(question);
            } else {
                String questionType = question != null ? question.getClass().getName() : null;
                QuestionAskedEvent event = new QuestionAskedEvent(questionType, this.request.getId());
                this.observationManager.notify((Event)event, (Object)this);
                if (event.isAnswered()) {
                    this.answered();
                } else {
                    this.answered.await();
                }
            }
            this.state = JobStatus.State.RUNNING;
        }
        finally {
            this.askLock.unlock();
        }
    }

    @Override
    public Object getQuestion() {
        return this.question;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void answered() {
        this.askLock.lock();
        try {
            if (this.isSubJob()) {
                this.question = null;
                this.parentJobStatus.answered();
            } else {
                String questionType = this.question != null ? this.question.getClass().getName() : null;
                this.observationManager.notify((Event)new QuestionAnsweredEvent(questionType, this.request.getId()), (Object)this);
                this.question = null;
                this.answered.signal();
            }
        }
        finally {
            this.askLock.unlock();
        }
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public boolean isSubJob() {
        return this.parentJobStatus != null;
    }

    @Unstable
    public JobStatus getParentJobStatus() {
        return this.parentJobStatus;
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    public void setIsolated(boolean isolated) {
        this.isolated = isolated;
    }

    @Override
    @Deprecated
    public List<LogEvent> getLog(LogLevel level) {
        return this.getLog().getLogs(level);
    }
}

