/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.event.status;

import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.job.event.status.QuestionEvent;
import org.xwiki.stability.Unstable;

@Unstable
public abstract class AbstractQuestionEvent
implements QuestionEvent {
    private final String questionType;
    private final List<String> jobId;

    public AbstractQuestionEvent() {
        this(null);
    }

    public AbstractQuestionEvent(String questionType) {
        this(questionType, null);
    }

    public AbstractQuestionEvent(String questionType, List<String> jobId) {
        this.questionType = questionType;
        this.jobId = jobId;
    }

    @Override
    public String getQuestionType() {
        return this.questionType;
    }

    @Override
    public List<String> getJobId() {
        return this.jobId;
    }

    public boolean matches(Object event) {
        return this.getClass() == event.getClass() && this.matchesQuestionType(((QuestionEvent)event).getQuestionType()) && this.matchesJobId(((QuestionEvent)event).getJobId());
    }

    private boolean matchesQuestionType(String questionType) {
        return questionType == null || this.questionType == null || this.questionType.equals(questionType);
    }

    private boolean matchesJobId(List<String> jobId) {
        return jobId == null || this.jobId == null || this.jobId.equals(jobId);
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 11).append(this.jobId).append((Object)this.questionType).build();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        QuestionEvent event = (QuestionEvent)object;
        return new EqualsBuilder().append(this.jobId, event.getJobId()).append((Object)this.questionType, (Object)event.getQuestionType()).build();
    }
}

