/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import org.xwiki.job.internal.xstream.XStreamUtils;

public class SafeThrowableConverter
implements Converter {
    private final Mapper mapper;
    private final Converter objectConverter;

    public SafeThrowableConverter(Mapper mapper, Converter objectConverter) {
        this.mapper = mapper;
        this.objectConverter = objectConverter;
    }

    public boolean canConvert(Class type) {
        return Throwable.class.isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Throwable throwable = (Throwable)source;
        XStreamUtils.serializeField("detailMessage", String.class, throwable.getMessage(), writer, context, this.mapper);
        XStreamUtils.serializeField("cause", Throwable.class, throwable.getCause(), writer, context, this.mapper);
        XStreamUtils.serializeField("stackTrace", StackTraceElement[].class, throwable.getStackTrace(), writer, context, this.mapper);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        return this.objectConverter.unmarshal(reader, context);
    }
}

