/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.config.LRUCacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.job.DefaultJobStatus;
import org.xwiki.job.JobManagerConfiguration;
import org.xwiki.job.JobStatusStore;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.job.internal.JobStatusSerializer;

@Component
@Singleton
public class DefaultJobStatusStore
implements JobStatusStore,
Initializable {
    private static final int VERSION = 1;
    private static final String FILENAME_STATUS = "status.xml";
    private static final String INDEX_FILE = "store.properties";
    private static final String INDEX_FILE_VERSION = "version";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String FOLDER_NULL = "&null";
    private static final JobStatus NOSTATUS = new DefaultJobStatus<Object>(null, null, null, null, null);
    @Inject
    private JobManagerConfiguration configuration;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private Logger logger;
    private JobStatusSerializer serializer;
    private ExecutorService executorService;
    private Cache<JobStatus> cache;

    public void initialize() throws InitializationException {
        try {
            this.serializer = new JobStatusSerializer();
            File folder = this.configuration.getStorage();
            File file = new File(folder, INDEX_FILE);
            FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class, null, true).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().properties().setFile(file)});
            PropertiesConfiguration properties = (PropertiesConfiguration)builder.getConfiguration();
            int version = properties.getInt(INDEX_FILE_VERSION, 0);
            if (1 > version) {
                this.repair();
                properties.setProperty(INDEX_FILE_VERSION, (Object)1);
                builder.save();
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to load jobs", (Throwable)e);
        }
        BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("Job status serializer").daemon(true).priority(1).build();
        this.executorService = new ThreadPoolExecutor(0, 10, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)threadFactory);
        LRUCacheConfiguration cacheConfiguration = new LRUCacheConfiguration("xwiki.groupservice.usergroups", this.configuration.getJobStatusCacheSize());
        try {
            this.cache = this.cacheManager.createNewCache((CacheConfiguration)cacheConfiguration);
        }
        catch (CacheException e) {
            throw new InitializationException("Failed to initialize job status cache", (Throwable)e);
        }
    }

    private String toUniqueString(List<String> id) {
        return StringUtils.join(id, (char)'/');
    }

    private String encode(String name) {
        String encoded;
        if (name != null) {
            try {
                encoded = URLEncoder.encode(name, DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                encoded = name;
            }
        } else {
            encoded = FOLDER_NULL;
        }
        return encoded;
    }

    private void repair() throws IOException {
        File folder = this.configuration.getStorage();
        if (folder.exists()) {
            if (!folder.isDirectory()) {
                throw new IOException("Not a directory: " + folder);
            }
            this.repairFolder(folder);
        }
    }

    private void repairFolder(File folder) {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                this.repairFolder(file);
                continue;
            }
            if (!file.getName().equals(FILENAME_STATUS)) continue;
            try {
                File properFolder;
                JobStatus status = this.loadStatus(folder);
                if (status == null || folder.equals(properFolder = this.getJobFolder(status.getRequest().getId()))) continue;
                try {
                    FileUtils.moveFileToDirectory((File)file, (File)properFolder, (boolean)true);
                }
                catch (IOException e) {
                    this.logger.error("Failed to move job status file", (Throwable)e);
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to load job status in folder [{}]", (Object)folder, (Object)e);
            }
        }
    }

    private JobStatus loadStatus(List<String> id) {
        return this.loadStatus(this.getJobFolder(id));
    }

    private JobStatus loadStatus(File folder) {
        File statusFile = new File(folder, FILENAME_STATUS);
        if (statusFile.exists()) {
            return this.loadJobStatus(statusFile);
        }
        return null;
    }

    private JobStatus loadJobStatus(File statusFile) {
        return this.serializer.read(statusFile);
    }

    private File getJobFolder(List<String> id) {
        File folder = this.configuration.getStorage();
        if (id != null) {
            for (String idElement : id) {
                folder = new File(folder, this.encode(idElement));
            }
        }
        return folder;
    }

    private void saveJobStatus(JobStatus status) {
        try {
            File statusFile = this.getJobFolder(status.getRequest().getId());
            statusFile = new File(statusFile, FILENAME_STATUS);
            this.serializer.write(status, statusFile);
        }
        catch (Exception e) {
            this.logger.warn("Failed to save job status [{}]", (Object)status, (Object)e);
        }
    }

    @Override
    public JobStatus getJobStatus(List<String> id) {
        String idString = this.toUniqueString(id);
        JobStatus status = (JobStatus)this.cache.get(idString);
        if (status == null) {
            status = this.maybeLoadStatus(id, idString);
        }
        return status == NOSTATUS ? null : status;
    }

    private synchronized JobStatus maybeLoadStatus(List<String> id, String idString) {
        JobStatus status = (JobStatus)this.cache.get(idString);
        if (status == null) {
            try {
                status = this.loadStatus(id);
                this.cache.set(idString, (Object)status);
            }
            catch (Exception e) {
                this.logger.warn("Failed to load job status for id {}", id, (Object)e);
                this.cache.remove(idString);
            }
        }
        return status;
    }

    @Override
    public void store(JobStatus status) {
        this.store(status, false);
    }

    @Override
    public void storeAsync(JobStatus status) {
        this.store(status, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(JobStatus status, boolean async) {
        if (status != null && status.getRequest() != null && status.getRequest().getId() != null) {
            Cache<JobStatus> cache = this.cache;
            synchronized (cache) {
                this.cache.set(this.toUniqueString(status.getRequest().getId()), (Object)status);
            }
            if (status.getClass().isAnnotationPresent(org.xwiki.job.annotation.Serializable.class) || status instanceof Serializable) {
                if (async) {
                    this.executorService.execute(new JobStatusSerializerRunnable(status));
                } else {
                    this.saveJobStatus(status);
                }
            }
        }
    }

    @Override
    public void remove(List<String> id) {
        File jobFolder = this.getJobFolder(id);
        if (jobFolder.exists()) {
            try {
                FileUtils.deleteDirectory((File)jobFolder);
            }
            catch (IOException e) {
                this.logger.warn("Failed to delete job folder [{}]", (Object)jobFolder, (Object)e);
            }
        }
        this.cache.remove(this.toUniqueString(id));
    }

    class JobStatusSerializerRunnable
    implements Runnable {
        private final JobStatus status;

        JobStatusSerializerRunnable(JobStatus status) {
            this.status = status;
        }

        @Override
        public void run() {
            DefaultJobStatusStore.this.saveJobStatus(this.status);
        }
    }
}

