/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.core.ReferenceByXPathUnmarshaller;
import com.thoughtworks.xstream.core.TreeUnmarshaller;
import com.thoughtworks.xstream.core.util.FastStack;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeTreeUnmarshaller
extends ReferenceByXPathUnmarshaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeTreeUnmarshaller.class);

    public SafeTreeUnmarshaller(Object root, HierarchicalStreamReader reader, ConverterLookup converterLookup, Mapper mapper) {
        super(root, reader, converterLookup, mapper);
    }

    protected Object convert(Object parent, Class type, Converter converter) {
        try {
            return super.convert(parent, type, converter);
        }
        catch (Throwable e) {
            try {
                FastStack types = (FastStack)FieldUtils.getDeclaredField(TreeUnmarshaller.class, (String)"types", (boolean)true).get((Object)this);
                types.popSilently();
            }
            catch (Exception e1) {
                LOGGER.debug("Failed to access private field com.thoughtworks.xstream.core.TreeUnmarshaller#types", (Object)type, (Object)e1);
            }
            LOGGER.debug("Got unknown exception when converting object of type [{}]", (Object)type, (Object)e);
            return null;
        }
    }
}

