/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging.event;

import javax.inject.Singleton;
import org.slf4j.helpers.MessageFormatter;
import org.xwiki.component.annotation.Component;
import org.xwiki.logging.LogLevel;
import org.xwiki.observation.event.Event;

@Component
@Singleton
public class LogEvent
implements Event {
    private LogLevel level;
    private String message;
    private Object[] argumentArray;
    private Throwable throwable;
    private transient String formattedMessage;

    public LogEvent() {
    }

    public LogEvent(LogLevel level, String message, Object[] argumentArray, Throwable throwable) {
        this.level = level;
        this.message = message;
        this.argumentArray = argumentArray;
        this.throwable = throwable;
    }

    public boolean matches(Object otherEvent) {
        return true;
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public Object[] getArgumentArray() {
        return this.argumentArray;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getFormattedMessage() {
        if (this.formattedMessage != null) {
            return this.formattedMessage;
        }
        this.formattedMessage = this.argumentArray != null ? MessageFormatter.arrayFormat((String)this.message, (Object[])this.argumentArray).getMessage() : this.message;
        return this.formattedMessage;
    }
}

