/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.event.LogEvent;

public class LogQueue
extends ConcurrentLinkedQueue<LogEvent>
implements Logger {
    private static final long serialVersionUID = 1L;

    public LogEvent addLogEvent(LogLevel level, String message, Object[] argumentArray) {
        Throwable throwable;
        Object[] actualArray;
        if (argumentArray.length > 0 && argumentArray[argumentArray.length - 1] instanceof Throwable) {
            actualArray = Arrays.copyOf(argumentArray, argumentArray.length - 1);
            throwable = (Throwable)argumentArray[argumentArray.length - 1];
        } else {
            actualArray = argumentArray;
            throwable = null;
        }
        return this.addLogEvent(level, message, actualArray, throwable);
    }

    public LogEvent addLogEvent(LogLevel level, String message, Object[] argumentArray, Throwable throwable) {
        LogEvent logEvent = new LogEvent(level, message, argumentArray, throwable);
        this.add(logEvent);
        return logEvent;
    }

    public List<LogEvent> getLogs(LogLevel level) {
        LinkedList<LogEvent> levelLogs = new LinkedList<LogEvent>();
        for (LogEvent log : this) {
            if (log.getLevel() != level) continue;
            levelLogs.add(log);
        }
        return levelLogs;
    }

    public String getName() {
        return null;
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public void trace(String msg) {
        this.trace(msg, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public void trace(String format, Object arg) {
        this.trace(format, new Object[]{arg});
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.trace(format, new Object[]{arg1, arg2});
    }

    public void trace(String format, Object[] argArray) {
        this.addLogEvent(LogLevel.TRACE, format, argArray);
    }

    public void trace(String msg, Throwable t) {
        this.addLogEvent(LogLevel.TRACE, msg, ArrayUtils.EMPTY_OBJECT_ARRAY, t);
    }

    public boolean isTraceEnabled(Marker marker) {
        return true;
    }

    public void trace(Marker marker, String msg) {
        this.trace(msg);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.trace(format, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.trace(format, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object[] argArray) {
        this.trace(format, argArray);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.trace(msg, t);
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public void debug(String msg) {
        this.debug(msg, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public void debug(String format, Object arg) {
        this.debug(format, new Object[]{arg});
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.debug(format, new Object[]{arg1, arg2});
    }

    public void debug(String format, Object[] argArray) {
        this.addLogEvent(LogLevel.DEBUG, format, argArray);
    }

    public void debug(String msg, Throwable t) {
        this.addLogEvent(LogLevel.DEBUG, msg, ArrayUtils.EMPTY_OBJECT_ARRAY, t);
    }

    public boolean isDebugEnabled(Marker marker) {
        return true;
    }

    public void debug(Marker marker, String msg) {
        this.debug(msg);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.debug(format, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.debug(format, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object[] argArray) {
        this.debug(format, argArray);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.debug(msg, t);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(String msg) {
        this.info(msg, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public void info(String format, Object arg) {
        this.info(format, new Object[]{arg});
    }

    public void info(String format, Object arg1, Object arg2) {
        this.info(format, new Object[]{arg1, arg2});
    }

    public void info(String format, Object[] argArray) {
        this.addLogEvent(LogLevel.INFO, format, argArray);
    }

    public void info(String msg, Throwable t) {
        this.addLogEvent(LogLevel.INFO, msg, ArrayUtils.EMPTY_OBJECT_ARRAY, t);
    }

    public boolean isInfoEnabled(Marker marker) {
        return true;
    }

    public void info(Marker marker, String msg) {
        this.info(msg);
    }

    public void info(Marker marker, String format, Object arg) {
        this.info(format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.info(format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object[] argArray) {
        this.info(format, argArray);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.info(msg, t);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String msg) {
        this.warn(msg, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public void warn(String format, Object arg) {
        this.warn(format, new Object[]{arg});
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.warn(format, new Object[]{arg1, arg2});
    }

    public void warn(String format, Object[] argArray) {
        this.addLogEvent(LogLevel.WARN, format, argArray);
    }

    public void warn(String msg, Throwable t) {
        this.addLogEvent(LogLevel.WARN, msg, ArrayUtils.EMPTY_OBJECT_ARRAY, t);
    }

    public boolean isWarnEnabled(Marker marker) {
        return true;
    }

    public void warn(Marker marker, String msg) {
        this.warn(msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.warn(format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.warn(format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object[] argArray) {
        this.warn(format, argArray);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.warn(msg, t);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(String msg) {
        this.error(msg, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public void error(String format, Object arg) {
        this.error(format, new Object[]{arg});
    }

    public void error(String format, Object arg1, Object arg2) {
        this.error(format, new Object[]{arg1, arg2});
    }

    public void error(String format, Object[] argArray) {
        this.addLogEvent(LogLevel.ERROR, format, argArray);
    }

    public void error(String msg, Throwable t) {
        this.addLogEvent(LogLevel.ERROR, msg, ArrayUtils.EMPTY_OBJECT_ARRAY, t);
    }

    public boolean isErrorEnabled(Marker marker) {
        return true;
    }

    public void error(Marker marker, String msg) {
        this.error(msg);
    }

    public void error(Marker marker, String format, Object arg) {
        this.error(format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.error(format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object[] argArray) {
        this.error(format, argArray);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.error(msg, t);
    }
}

